@extends('layouts.app')

@section('title', 'MPESA Dashboard')

@section('style')
    <!-- Additional styles if needed -->
    <style>
        .card-gradient-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .card-gradient-success {
            background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
            color: white;
        }
        .card-gradient-info {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            color: white;
        }
        .card-gradient-warning {
            background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
            color: white;
        }
        .stat-icon {
            font-size: 2rem;
            opacity: 0.8;
        }
        .chart-container {
            position: relative;
            height: 300px;
        }
        .phone-number {
            direction: ltr;
            unicode-bidi: embed;
        }
    </style>
@endsection

@section('content')
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Payments</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">MPESA Dashboard</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="{{ route('payments.mpesa.configuration') }}" class="btn btn-outline-primary">
                        <i class="bx bx-cog me-1"></i> Configuration
                    </a>
                    <a href="{{ route('payments.mpesa.transactions') }}" class="btn btn-outline-primary">
                        <i class="bx bx-list-ul me-1"></i> Transactions
                    </a>
                    <a href="{{ route('payments.mpesa.reports.daily') }}" class="btn btn-outline-primary">
                        <i class="bx bx-bar-chart me-1"></i> Reports
                    </a>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="row row-cols-1 row-cols-lg-4 row-cols-xl-4 g-3">
            <!-- Total Transactions Card -->
            <div class="col">
                <div class="card card-gradient-primary radius-10">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-white">Total Transactions</p>
                                <h4 class="my-1 text-white">{{ number_format($stats['total']['transactions']) }}</h4>
                                <p class="mb-0 text-white-50">
                                    <i class="bx bx-up-arrow-alt"></i> Today: {{ number_format($stats['today']['transactions']) }}
                                </p>
                            </div>
                            <div class="text-white ms-auto font-35">
                                <i class="bx bx-transfer stat-icon"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Amount Card -->
            <div class="col">
                <div class="card card-gradient-success radius-10">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-white">Total Amount</p>
                                <h4 class="my-1 text-white">Ksh {{ number_format($stats['total']['amount'], 2) }}</h4>
                                <p class="mb-0 text-white-50">
                                    <i class="bx bx-up-arrow-alt"></i> Today: Ksh {{ number_format($stats['today']['amount'], 2) }}
                                </p>
                            </div>
                            <div class="text-white ms-auto font-35">
                                <i class="bx bx-money stat-icon"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Matched Transactions Card -->
            <div class="col">
                <div class="card card-gradient-info radius-10">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-white">Matched Transactions</p>
                                <h4 class="my-1 text-white">{{ number_format($stats['total']['matched']) }}</h4>
                                <p class="mb-0 text-white-50">
                                    @if($stats['today']['unmatched'] > 0)
                                        <i class="bx bx-error text-warning"></i>
                                    @else
                                        <i class="bx bx-check-circle text-success"></i>
                                    @endif
                                    Unmatched: {{ $stats['today']['unmatched'] }}
                                </p>
                            </div>
                            <div class="text-white ms-auto font-35">
                                <i class="bx bx-link stat-icon"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Active Credentials Card -->
            <div class="col">
                <div class="card card-gradient-warning radius-10">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-white">Active Credentials</p>
                                <h4 class="my-1 text-white">{{ $credentials->count() }}</h4>
                                <p class="mb-0 text-white-50">
                                    @if($credentials->where('is_active', true)->first())
                                        <i class="bx bx-check-circle text-success"></i>
                                        {{ $credentials->where('is_active', true)->first()->environment_display }}
                                    @else
                                        <i class="bx bx-error text-danger"></i> No active credentials
                                    @endif
                                </p>
                            </div>
                            <div class="text-white ms-auto font-35">
                                <i class="bx bx-key stat-icon"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!--end row-->

        <div class="row">
            <!-- Chart Column -->
            <div class="col-12 col-lg-8">
                <div class="card radius-10">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">Transaction Activity (Last 7 Days)</h6>
                            </div>
                            <div class="dropdown ms-auto">
                                <a class="dropdown-toggle dropdown-toggle-nocaret" href="#" data-bs-toggle="dropdown">
                                    <i class='bx bx-dots-horizontal-rounded font-22 text-option'></i>
                                </a>
                                <ul class="dropdown-menu">
                                    <li>
                                        <a class="dropdown-item" href="{{ route('payments.mpesa.reports.daily') }}">
                                            <i class="bx bx-bar-chart me-2"></i>View Detailed Reports
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="chart-container">
                            <canvas id="mpesaChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions Column -->
            <div class="col-12 col-lg-4">
                <!-- Credentials Status Card -->
                <div class="card radius-10 mb-3">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">Credentials Status</h6>
                            </div>
                        </div>
                        <hr>
                        @if($credentials->count() > 0)
                            @foreach($credentials as $credential)
                                <div class="credentials-item mb-3">
                                    <div class="d-flex align-items-center">
                                        <div class="widgets-icons bg-light-{{ $credential->is_active ? 'success' : 'warning' }} text-{{ $credential->is_active ? 'success' : 'warning' }} rounded-circle me-3">
                                            <i class="bx bx-key"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1">{{ $credential->name }}</h6>
                                            <p class="mb-0">
                                                {{ $credential->shortcode_masked }} • {{ $credential->environment_display }}
                                                @if($credential->is_active)
                                                    <span class="badge bg-success ms-2">Active</span>
                                                @endif
                                            </p>
                                            @if($credential->last_success)
                                                <small class="text-success">
                                                    <i class="bx bx-check-circle"></i> 
                                                    Last success: {{ $credential->last_success->diffForHumans() }}
                                                </small>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                @if(!$loop->last)
                                    <hr class="my-2">
                                @endif
                            @endforeach
                        @else
                            <div class="text-center py-4">
                                <div class="widgets-icons bg-light-secondary text-secondary rounded-circle mx-auto mb-3">
                                    <i class="bx bx-key"></i>
                                </div>
                                <p class="text-muted mb-3">No credentials configured</p>
                                <a href="{{ route('payments.mpesa.configuration') }}" class="btn btn-primary btn-sm">
                                    <i class="bx bx-plus me-1"></i> Add Credentials
                                </a>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Quick Actions Card -->
                <div class="card radius-10">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">Quick Actions</h6>
                            </div>
                        </div>
                        <hr>
                        <div class="row g-2">
                            <div class="col-6">
                                <a href="{{ route('payments.mpesa.test') }}" class="btn btn-outline-primary w-100">
                                    <i class="bx bx-test-tube me-1"></i> Test
                                </a>
                            </div>
                            <div class="col-6">
                                <a href="{{ route('payments.mpesa.settings') }}" class="btn btn-outline-secondary w-100">
                                    <i class="bx bx-slider me-1"></i> Settings
                                </a>
                            </div>
                            <div class="col-6">
                                <a href="{{ route('payments.mpesa.reports.unmatched') }}" class="btn btn-outline-warning w-100">
                                    <i class="bx bx-unlink me-1"></i> Unmatched
                                </a>
                            </div>
                            <div class="col-6">
                                <a href="{{ route('payments.mpesa.reports.reconciliation') }}" class="btn btn-outline-info w-100">
                                    <i class="bx bx-balance me-1"></i> Reconcile
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!--end row-->

        <!-- Recent Transactions -->
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div>
                        <h6 class="mb-0">Recent Transactions</h6>
                    </div>
                    <div class="dropdown ms-auto">
                        <a href="{{ route('payments.mpesa.transactions') }}" class="btn btn-primary btn-sm">
                            View All <i class="bx bx-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
                <hr>
                <div class="table-responsive">
                    <table class="table align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Transaction ID</th>
                                <th>Phone</th>
                                <th>Amount</th>
                                <th>Date</th>
                                <th>Status</th>
                                <th>Sale</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($recentTransactions as $transaction)
                                <tr>
                                    <td>
                                        <code>{{ $transaction->transaction_id }}</code>
                                        @if($transaction->mpesa_receipt_number)
                                            <br><small class="text-muted">Receipt: {{ $transaction->mpesa_receipt_number }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="phone-number">{{ $transaction->formatted_phone }}</span>
                                        @if($transaction->full_name)
                                            <br><small class="text-muted">{{ $transaction->full_name }}</small>
                                        @endif
                                    </td>
                                    <td class="fw-bold">Ksh {{ number_format($transaction->amount, 2) }}</td>
                                    <td>
                                        {{ $transaction->transaction_date->format('M d, Y') }}<br>
                                        <small class="text-muted">{{ $transaction->transaction_date->format('h:i A') }}</small>
                                    </td>
                                    <td>
                                        @if($transaction->status == 'completed')
                                            <span class="badge bg-success">Completed</span>
                                        @elseif($transaction->status == 'pending')
                                            <span class="badge bg-warning">Pending</span>
                                        @elseif($transaction->status == 'failed')
                                            <span class="badge bg-danger">Failed</span>
                                        @elseif($transaction->status == 'reversed')
                                            <span class="badge bg-secondary">Reversed</span>
                                        @elseif($transaction->status == 'matched')
                                            <span class="badge bg-primary">Matched</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($transaction->sale_id)
                                            <a href="{{ route('sales.show', $transaction->sale_id) }}" class="badge bg-info">
                                                Sale #{{ $transaction->sale_id }}
                                            </a>
                                        @else
                                            <span class="badge bg-warning">Unmatched</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="d-flex order-actions">
                                            <a href="{{ route('payments.mpesa.transactions.show', $transaction->id) }}" 
                                               class="btn btn-sm btn-outline-primary me-2">
                                                <i class="bx bx-show"></i>
                                            </a>
                                            @if(!$transaction->sale_id && $transaction->status == 'completed')
                                                <button class="btn btn-sm btn-outline-success" 
                                                        data-bs-toggle="modal" 
                                                        data-bs-target="#matchModal{{ $transaction->id }}">
                                                    <i class="bx bx-link"></i>
                                                </button>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center py-4">
                                        <div class="widgets-icons bg-light-secondary text-secondary rounded-circle mx-auto mb-3">
                                            <i class="bx bx-transfer"></i>
                                        </div>
                                        <p class="text-muted">No recent transactions</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Top Phones -->
        @if($topPhones->count() > 0)
        <div class="card radius-10 mt-3">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div>
                        <h6 class="mb-0">Top Customers by Transaction Volume</h6>
                    </div>
                </div>
                <hr>
                <div class="table-responsive">
                    <table class="table mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Phone</th>
                                <th>Transactions</th>
                                <th>Total Amount</th>
                                <th>Matched</th>
                                <th>Unmatched</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($topPhones as $phone => $data)
                                <tr>
                                    <td>
                                        <span class="phone-number">{{ $phone }}</span>
                                        @php
                                            $customer = \App\Models\Customer::where('phone', $phone)->first();
                                        @endphp
                                        @if($customer)
                                            <br><small class="text-muted">{{ $customer->name }}</small>
                                        @endif
                                    </td>
                                    <td>{{ $data->transaction_count }}</td>
                                    <td class="fw-bold">Ksh {{ number_format($data->total_amount, 2) }}</td>
                                    <td>{{ $data->matched }}</td>
                                    <td>{{ $data->unmatched }}</td>
                                    <td>
                                        <div class="d-flex order-actions">
                                            <a href="{{ route('payments.mpesa.transactions.by-phone', $phone) }}" 
                                               class="btn btn-sm btn-outline-primary me-1">
                                                <i class="bx bx-list-ul"></i>
                                            </a>
                                            @if($customer)
                                                <a href="{{ route('customers.show', $customer->id) }}" 
                                                   class="btn btn-sm btn-outline-info">
                                                    <i class="bx bx-user"></i>
                                                </a>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
<!--end page wrapper -->
@endsection

@section('script')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Chart Data from PHP
    const chartData = @json($chartData);

    // Prepare chart data
    const labels = chartData.map(item => item.date);
    const amounts = chartData.map(item => item.amount);
    const counts = chartData.map(item => item.count);

    // Create chart
    const ctx = document.getElementById('mpesaChart').getContext('2d');
    const mpesaChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: labels,
            datasets: [{
                label: 'Amount (Ksh)',
                data: amounts,
                borderColor: '#4e73df',
                backgroundColor: 'rgba(78, 115, 223, 0.05)',
                borderWidth: 2,
                fill: true,
                tension: 0.4,
                yAxisID: 'y'
            }, {
                label: 'Transaction Count',
                data: counts,
                borderColor: '#1cc88a',
                backgroundColor: 'rgba(28, 200, 138, 0.05)',
                borderWidth: 2,
                fill: true,
                tension: 0.4,
                yAxisID: 'y1'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: {
                mode: 'index',
                intersect: false,
            },
            scales: {
                x: {
                    grid: {
                        display: false
                    }
                },
                y: {
                    type: 'linear',
                    display: true,
                    position: 'left',
                    title: {
                        display: true,
                        text: 'Amount (Ksh)'
                    },
                    grid: {
                        drawBorder: false
                    }
                },
                y1: {
                    type: 'linear',
                    display: true,
                    position: 'right',
                    title: {
                        display: true,
                        text: 'Count'
                    },
                    grid: {
                        drawOnChartArea: false,
                    },
                }
            },
            plugins: {
                legend: {
                    position: 'top',
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            let label = context.dataset.label || '';
                            if (label) {
                                label += ': ';
                            }
                            if (context.dataset.label.includes('Amount')) {
                                label += 'Ksh ' + context.parsed.y.toLocaleString();
                            } else {
                                label += context.parsed.y;
                            }
                            return label;
                        }
                    }
                }
            }
        }
    });

    // Auto-refresh dashboard every 60 seconds
    setInterval(function() {
        location.reload();
    }, 60000);
</script>
@endsection