@extends("layouts.app")

@section("style")
    <link href="{{ asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />
    <style>
        .stat-card {
            border-radius: 10px;
            transition: all 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
        .quick-action-btn {
            height: 100px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            border-radius: 10px;
            transition: all 0.3s ease;
        }
        .quick-action-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .quick-action-btn i {
            font-size: 2rem;
            margin-bottom: 10px;
        }
        .cursor-pointer {
            cursor: pointer;
        }
        .widgets-icons {
            width: 50px;
            height: 50px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 10px;
        }
        .recent-product-img {
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #f8f9fa;
            border-radius: 6px;
            margin-right: 10px;
        }
        .product-img img {
            width: 40px;
            height: 40px;
            object-fit: cover;
            border-radius: 6px;
        }
    </style>
@endsection

@section("content")
<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Dashboard</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">Overview</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <button type="button" class="btn btn-primary" onclick="refreshDashboard()">
                    <i class="bx bx-refresh"></i> Refresh
                </button>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-3 g-4 mb-4">
            <!-- Revenue Card -->
            <div class="col">
                <div class="card radius-10 stat-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <p class="mb-1 text-secondary">Total Revenue</p>
                                <h4 class="my-1 text-primary" id="totalRevenue">KES 0.00</h4>
                                <p class="mb-0 font-13 text-success" id="revenueChange">
                                    <i class='bx bxs-up-arrow align-middle'></i>0% Since last week
                                </p>
                            </div>
                            <div class="widgets-icons bg-light-primary text-primary ms-auto">
                                <i class='bx bx-money'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Sales Card -->
            <div class="col">
                <div class="card radius-10 stat-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <p class="mb-1 text-secondary">Total Sales</p>
                                <h4 class="my-1 text-success" id="totalSales">0</h4>
                                <p class="mb-0 font-13 text-success" id="salesChange">
                                    <i class='bx bxs-up-arrow align-middle'></i>0% Since last week
                                </p>
                            </div>
                            <div class="widgets-icons bg-light-success text-success ms-auto">
                                <i class='bx bx-cart'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Today's Sales Card -->
            <div class="col">
                <div class="card radius-10 stat-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <p class="mb-1 text-secondary">Today's Sales</p>
                                <h4 class="my-1 text-danger" id="todaySales">KES 0.00</h4>
                                <p class="mb-0 font-13 text-success" id="todaySalesChange">
                                    <i class='bx bxs-up-arrow align-middle'></i>0% Since last week
                                </p>
                            </div>
                            <div class="widgets-icons bg-light-danger text-danger ms-auto">
                                <i class='bx bx-calendar'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customers Card -->
            <div class="col">
                <div class="card radius-10 stat-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <p class="mb-1 text-secondary">Total Customers</p>
                                <h4 class="my-1 text-warning" id="totalCustomers">0</h4>
                                <p class="mb-0 font-13 text-success" id="customersChange">
                                    <i class='bx bxs-up-arrow align-middle'></i>0% Since last week
                                </p>
                            </div>
                            <div class="widgets-icons bg-light-warning text-warning ms-auto">
                                <i class='bx bx-group'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Products Card -->
            <div class="col">
                <div class="card radius-10 stat-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <p class="mb-1 text-secondary">Total Products</p>
                                <h4 class="my-1 text-info" id="totalProducts">0</h4>
                                <p class="mb-0 font-13 text-success" id="productsChange">
                                    <i class='bx bxs-up-arrow align-middle'></i>0% Since last week
                                </p>
                            </div>
                            <div class="widgets-icons bg-light-info text-info ms-auto">
                                <i class='bx bx-package'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pending Orders Card -->
            <div class="col">
                <div class="card radius-10 stat-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <p class="mb-1 text-secondary">Pending Orders</p>
                                <h4 class="my-1 text-secondary" id="pendingOrders">0</h4>
                                <p class="mb-0 font-13 text-success" id="pendingOrdersChange">
                                    <i class='bx bxs-up-arrow align-middle'></i>0% Since last week
                                </p>
                            </div>
                            <div class="widgets-icons bg-light-secondary text-secondary ms-auto">
                                <i class='bx bx-time'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Store Metrics and Sales Chart -->
        <div class="row row-cols-1 row-cols-xl-2">
            <div class="col d-flex">
                <div class="card radius-10 w-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <h5 class="mb-1">Store Metrics</h5>
                                <p class="mb-0 font-13 text-secondary">
                                    <i class='bx bxs-calendar'></i> Last 30 days overview
                                </p>
                            </div>
                            <div class="font-22 ms-auto">
                                <i class='bx bx-dots-horizontal-rounded'></i>
                            </div>
                        </div>
                        <div class="row row-cols-1 row-cols-sm-3 mt-4">
                            <div class="col">
                                <div>
                                    <p class="mb-0 text-secondary">Revenue</p>
                                    <h4 class="my-1" id="monthRevenue">KES 0.00</h4>
                                    <p class="mb-0 font-13 text-success" id="monthRevenueChange">
                                        <i class='bx bxs-up-arrow align-middle'></i>0% Since last month
                                    </p>
                                </div>
                            </div>
                            <div class="col">
                                <div>
                                    <p class="mb-0 text-secondary">Total Sales</p>
                                    <h4 class="my-1" id="monthSales">0</h4>
                                    <p class="mb-0 font-13 text-success" id="monthSalesChange">
                                        <i class='bx bxs-up-arrow align-middle'></i>0% Since last month
                                    </p>
                                </div>
                            </div>
                            <div class="col">
                                <div>
                                    <p class="mb-0 text-secondary">New Customers</p>
                                    <h4 class="my-1" id="monthCustomers">0</h4>
                                    <p class="mb-0 font-13 text-success" id="monthCustomersChange">
                                        <i class='bx bxs-up-arrow align-middle'></i>0% Since last month
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- Sales Chart -->
                        <div class="mt-3">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h6 class="mb-0">Sales Overview</h6>
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-outline-primary dropdown-toggle" type="button" id="periodDropdown" data-bs-toggle="dropdown">
                                        Last 30 days
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="#" onclick="changePeriod(7)">Last 7 days</a></li>
                                        <li><a class="dropdown-item" href="#" onclick="changePeriod(30)">Last 30 days</a></li>
                                        <li><a class="dropdown-item" href="#" onclick="changePeriod(90)">Last 90 days</a></li>
                                        <li><a class="dropdown-item" href="#" onclick="changePeriod(365)">Last Year</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div id="salesChart" style="height: 200px;"></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col d-flex">
                <div class="card radius-10 w-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <h5 class="mb-1">Top Products</h5>
                                <p class="mb-0 font-13 text-secondary">
                                    <i class='bx bxs-calendar'></i> Best selling products
                                </p>
                            </div>
                            <div class="font-22 ms-auto">
                                <i class='bx bx-dots-horizontal-rounded'></i>
                            </div>
                        </div>
                        <div class="product-list p-3 mb-3" id="topProducts">
                            <div class="text-center py-3">
                                <div class="spinner-border spinner-border-sm text-primary" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                                <span class="ms-2">Loading top products...</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card radius-10">
                    <div class="card-body">
                        <h5 class="card-title mb-3">Quick Actions</h5>
                        <div class="row g-3">
                            <div class="col-md-3 col-sm-6">
                                <a href="{{ route('pos.index') }}" class="btn btn-primary quick-action-btn">
                                    <i class='bx bx-cart-add'></i>
                                    <span>New Sale</span>
                                </a>
                            </div>
                            <div class="col-md-3 col-sm-6">
                                <a href="{{ route('products.create') }}" class="btn btn-success quick-action-btn">
                                    <i class='bx bx-plus'></i>
                                    <span>Add Product</span>
                                </a>
                            </div>
                            <div class="col-md-3 col-sm-6">
                                <a href="{{ route('customers.create') }}" class="btn btn-info quick-action-btn">
                                    <i class='bx bx-user-plus'></i>
                                    <span>Add Customer</span>
                                </a>
                            </div>
                            <div class="col-md-3 col-sm-6">
                                <a href="{{ route('purchases.create') }}" class="btn btn-warning quick-action-btn">
                                    <i class='bx bx-package'></i>
                                    <span>New Purchase</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Orders Table -->
        <div class="row">
            <div class="col-12">
                <div class="card radius-10">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <h5 class="mb-0">Recent Orders</h5>
                            </div>
                            <div class="font-22 ms-auto">
                                <i class='bx bx-dots-horizontal-rounded'></i>
                            </div>
                        </div>
                        <hr/>
                        <div class="table-responsive">
                            <table class="table align-middle mb-0" id="recentOrders">
                                <thead class="table-light">
                                    <tr>
                                        <th>Order ID</th>
                                        <th>Customer</th>
                                        <th>Date</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="6" class="text-center py-4">
                                            <div class="spinner-border spinner-border-sm text-primary" role="status">
                                                <span class="visually-hidden">Loading...</span>
                                            </div>
                                            <span class="ms-2">Loading recent orders...</span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--end row-->
    </div>
</div>
@endsection

@section("script")
<script src="{{ asset('assets/plugins/apexcharts-bundle/js/apexcharts.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

<script>
    let salesChart = null;
    let currentPeriod = 30;

    $(document).ready(function() {
        loadDashboardData(currentPeriod);
        loadRecentOrders();
        loadTopProducts();
        loadMonthlyMetrics();
    });

    function refreshDashboard() {
        loadDashboardData(currentPeriod);
        loadRecentOrders();
        loadTopProducts();
        loadMonthlyMetrics();
        toastr.success('Dashboard refreshed!');
    }

    function changePeriod(days) {
        currentPeriod = days;
        $('#periodDropdown').text('Last ' + days + ' days');
        loadDashboardData(days);
    }

    function loadDashboardData(period = 30) {
        $.ajax({
            url: '{{ route("dashboard.data") }}',
            method: 'GET',
            data: { period: period },
            success: function(response) {
                if (response.success) {
                    // Update cards
                    updateCard('totalRevenue', response.total_revenue, response.revenue_change, true);
                    updateCard('totalSales', response.total_sales, response.sales_change, false);
                    updateCard('todaySales', response.today_sales, response.today_sales_change, true);
                    updateCard('totalCustomers', response.total_customers, response.customers_change, false);
                    updateCard('totalProducts', response.total_products, response.products_change, false);
                    updateCard('pendingOrders', response.pending_orders, response.pending_orders_change, false);
                    
                    // Update chart
                    updateSalesChart(response.sales_overview);
                } else {
                    toastr.error('Error loading data');
                }
            },
            error: function(xhr) {
                console.error('Dashboard error:', xhr);
                toastr.error('Failed to load dashboard data');
            }
        });
    }

    function loadMonthlyMetrics() {
        $.ajax({
            url: '{{ route("dashboard.monthly-metrics") }}',
            method: 'GET',
            success: function(response) {
                if (response.success) {
                    updateMonthlyCard('monthRevenue', response.month_revenue, response.month_revenue_change, true);
                    updateMonthlyCard('monthSales', response.month_sales, response.month_sales_change, false);
                    updateMonthlyCard('monthCustomers', response.month_customers, response.month_customers_change, false);
                }
            },
            error: function(xhr) {
                console.error('Monthly metrics error:', xhr);
            }
        });
    }

    function loadRecentOrders() {
        $.ajax({
            url: '{{ route("dashboard.recent-orders") }}',
            method: 'GET',
            success: function(response) {
                if (response.success) {
                    let tbody = $('#recentOrders tbody');
                    tbody.empty();
                    
                    if (response.orders.length === 0) {
                        tbody.append(`
                            <tr>
                                <td colspan="6" class="text-center py-4 text-muted">
                                    No recent orders found
                                </td>
                            </tr>
                        `);
                        return;
                    }
                    
                    response.orders.forEach(function(order) {
                        let statusClass = getStatusClass(order.status);
                        let statusIcon = getStatusIcon(order.status);
                        let statusText = order.status.charAt(0).toUpperCase() + order.status.slice(1);
                        
                        let row = `
                            <tr>
                                <td>
                                    <a href="/sales/${order.id}" class="text-primary text-decoration-none">
                                        ${order.order_id}
                                    </a>
                                </td>
                                <td>${order.customer_name}</td>
                                <td>${order.order_date}</td>
                                <td class="fw-bold">KES ${parseFloat(order.total).toLocaleString('en-KE', {minimumFractionDigits: 2})}</td>
                                <td>
                                    <span class="badge bg-${statusClass}">
                                        <i class="bx ${statusIcon} me-1"></i>${statusText}
                                    </span>
                                </td>
                                <td>
                                    <a href="/sales/${order.id}" class="btn btn-sm btn-outline-primary">
                                        <i class="bx bx-show"></i>
                                    </a>
                                </td>
                            </tr>
                        `;
                        tbody.append(row);
                    });
                }
            },
            error: function(xhr) {
                console.error('Recent orders error:', xhr);
                let tbody = $('#recentOrders tbody');
                tbody.empty();
                tbody.append(`
                    <tr>
                        <td colspan="6" class="text-center py-4 text-danger">
                            Error loading recent orders
                        </td>
                    </tr>
                `);
            }
        });
    }

    function loadTopProducts() {
        $.ajax({
            url: '{{ route("dashboard.top-products") }}',
            method: 'GET',
            success: function(html) {
                $('#topProducts').html(html);
            },
            error: function(xhr) {
                console.error('Top products error:', xhr);
                $('#topProducts').html(`
                    <div class="text-center py-4 text-danger">
                        Error loading top products
                    </div>
                `);
            }
        });
    }

    function updateCard(elementId, value, change, isCurrency) {
        const element = $('#' + elementId);
        const changeElement = $('#' + elementId + 'Change');
        
        if (isCurrency) {
            element.text(formatCurrency(value));
        } else {
            element.text(value.toLocaleString());
        }
        
        const changeIcon = change >= 0 ? 'bxs-up-arrow text-success' : 'bxs-down-arrow text-danger';
        const changeText = Math.abs(change) + '% Since last week';
        
        changeElement.html(`<i class="bx ${changeIcon} align-middle"></i> ${changeText}`);
    }

    function updateMonthlyCard(elementId, value, change, isCurrency) {
        const element = $('#' + elementId);
        const changeElement = $('#' + elementId + 'Change');
        
        if (isCurrency) {
            element.text(formatCurrency(value));
        } else {
            element.text(value.toLocaleString());
        }
        
        const changeIcon = change >= 0 ? 'bxs-up-arrow text-success' : 'bxs-down-arrow text-danger';
        const changeText = Math.abs(change) + '% Since last month';
        
        changeElement.html(`<i class="bx ${changeIcon} align-middle"></i> ${changeText}`);
    }

    function formatCurrency(amount) {
        return 'KES ' + parseFloat(amount).toLocaleString('en-KE', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
    }

    function getStatusClass(status) {
        const classes = {
            'pending': 'warning',
            'completed': 'success',
            'cancelled': 'danger',
            'refunded': 'info',
            'processing': 'primary',
            'paid': 'success',
            'unpaid': 'warning'
        };
        return classes[status.toLowerCase()] || 'secondary';
    }

    function getStatusIcon(status) {
        const icons = {
            'pending': 'bx-time',
            'completed': 'bx-check-circle',
            'cancelled': 'bx-x-circle',
            'refunded': 'bx-refresh',
            'processing': 'bx-loader-circle',
            'paid': 'bx-check-circle',
            'unpaid': 'bx-time'
        };
        return icons[status.toLowerCase()] || 'bx-question-mark';
    }

    function updateSalesChart(data) {
        if (!data || !data.labels || !data.series) {
            $('#salesChart').html('<div class="text-center py-5 text-muted">No sales data available</div>');
            return;
        }

        if (salesChart) {
            salesChart.destroy();
        }

        const options = {
            series: [{
                name: 'Sales',
                data: data.series
            }],
            chart: {
                type: 'line',
                height: 200,
                toolbar: {
                    show: false
                },
                zoom: {
                    enabled: false
                }
            },
            stroke: {
                curve: 'smooth',
                width: 3
            },
            colors: ['#5c60f5'],
            markers: {
                size: 4
            },
            grid: {
                show: true,
                borderColor: '#f0f0f0',
                strokeDashArray: 3
            },
            xaxis: {
                categories: data.labels,
                labels: {
                    style: {
                        colors: '#787878',
                        fontSize: '11px'
                    }
                }
            },
            yaxis: {
                labels: {
                    formatter: function(val) {
                        return 'KES ' + val.toLocaleString();
                    },
                    style: {
                        colors: '#787878',
                        fontSize: '11px'
                    }
                }
            },
            tooltip: {
                y: {
                    formatter: function(val) {
                        return 'KES ' + val.toLocaleString('en-KE', {
                            minimumFractionDigits: 2,
                            maximumFractionDigits: 2
                        });
                    }
                }
            }
        };

        salesChart = new ApexCharts(document.querySelector("#salesChart"), options);
        salesChart.render();
    }
</script>
@endsection