@extends('layouts.app')

@section('style')
    <style>
        .info-card {
            border-left: 4px solid #667eea;
            background: #f8f9fa;
        }
        .sale-card {
            transition: all 0.3s;
            border-left: 4px solid transparent;
        }
        .sale-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            border-left-color: #667eea;
        }
        .customer-avatar-lg {
            width: 100px;
            height: 100px;
            background: linear-gradient(45deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 40px;
            font-weight: bold;
            margin: 0 auto;
        }
        .status-badge {
            font-size: 0.75rem;
            padding: 0.25rem 0.75rem;
        }
        .info-label {
            color: #6c757d;
            font-weight: 500;
            min-width: 150px;
        }
        .info-value {
            color: #495057;
            font-weight: 400;
        }
        .balance-positive { color: #198754; }
        .balance-negative { color: #dc3545; }
        .balance-zero { color: #6c757d; }
        .stat-card {
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 10px;
        }
        .vat-badge {
            background: linear-gradient(45deg, #8B5CF6, #7C3AED);
            color: white;
        }
        .loyalty-badge {
            background: linear-gradient(45deg, #F59E0B, #D97706);
            color: white;
        }
        .level-badge.platinum { background: linear-gradient(45deg, #E5E7EB, #9CA3AF); color: #000; }
        .level-badge.gold { background: linear-gradient(45deg, #FBBF24, #F59E0B); color: #000; }
        .level-badge.silver { background: linear-gradient(45deg, #D1D5DB, #9CA3AF); color: #000; }
        .level-badge.bronze { background: linear-gradient(45deg, #FCD34D, #F59E0B); color: #000; }
    </style>
@endsection

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Customers</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('customers.index') }}">Customers</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ $customer->name }}</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="{{ route('customers.edit', $customer) }}" class="btn btn-primary">
                        <i class="bx bx-edit"></i> Edit Customer
                    </a>
                    <a href="{{ route('pos.index') }}?customer_id={{ $customer->id }}" 
                       class="btn btn-success">
                        <i class="bx bx-cart-add"></i> New Sale
                    </a>
                    <button type="button" class="btn btn-primary split-bg-primary dropdown-toggle dropdown-toggle-split" 
                            data-bs-toggle="dropdown">
                        <span class="visually-hidden">Toggle Dropdown</span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end">
                        <a class="dropdown-item" href="#" onclick="window.print()">
                            <i class="bx bx-printer"></i> Print Details
                        </a>
                        <a class="dropdown-item" href="#" id="generateStatementBtn">
                            <i class="bx bx-file"></i> Generate Statement
                        </a>
                        <a class="dropdown-item" href="mailto:{{ $customer->email }}" 
                           {{ !$customer->email ? 'disabled' : '' }}>
                            <i class="bx bx-envelope"></i> Send Email
                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item text-warning" href="#" data-bs-toggle="modal" data-bs-target="#resetStatsModal">
                            <i class="bx bx-reset"></i> Reset Statistics
                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item text-danger delete-customer" href="#"
                           data-id="{{ $customer->id }}"
                           data-name="{{ $customer->name }}">
                            <i class="bx bx-trash"></i> Delete Customer
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Customer Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-md-2 text-center">
                                <div class="customer-avatar-lg mb-3">
                                    {{ strtoupper(substr($customer->name, 0, 1)) }}
                                </div>
                                <div class="level-badge {{ $customer->customer_level }} badge mb-2">
                                    <i class="bx bx-award"></i> {{ ucfirst($customer->customer_level) }}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h4 class="mb-1">{{ $customer->name }}</h4>
                                @if($customer->company_name)
                                    <p class="text-muted mb-2">
                                        <i class="bx bx-building"></i> {{ $customer->company_name }}
                                    </p>
                                @endif
                                <div class="d-flex flex-wrap gap-2 mb-3">
                                    @if($customer->customer_type == 'walk-in')
                                        <span class="badge bg-warning text-dark status-badge">
                                            <i class="bx bx-walk"></i> Walk-in Customer
                                        </span>
                                    @elseif($customer->customer_type == 'regular')
                                        <span class="badge bg-success status-badge">
                                            <i class="bx bx-user"></i> Regular Customer
                                        </span>
                                    @else
                                        <span class="badge bg-primary status-badge">
                                            <i class="bx bx-building"></i> Business Customer
                                        </span>
                                    @endif
                                    
                                    @if($customer->status == 'active')
                                        <span class="badge bg-light-success text-success status-badge">
                                            <i class="bx bx-check-circle"></i> Active
                                        </span>
                                    @else
                                        <span class="badge bg-light-secondary text-secondary status-badge">
                                            <i class="bx bx-time"></i> Inactive
                                        </span>
                                    @endif
                                    
                                    @if($customer->is_vat_registered)
                                        <span class="badge vat-badge status-badge">
                                            <i class="bx bx-check"></i> VAT Registered
                                        </span>
                                    @endif
                                    
                                    @if($customer->loyalty_points > 0)
                                        <span class="badge loyalty-badge status-badge">
                                            <i class="bx bx-gift"></i> {{ $customer->loyalty_points }} points
                                        </span>
                                    @endif
                                    
                                    @if($customer->discount_percent > 0)
                                        <span class="badge bg-info status-badge">
                                            <i class="bx bx-discount"></i> {{ $customer->discount_percent }}% Discount
                                        </span>
                                    @endif
                                    
                                    <span class="badge bg-light-info text-info status-badge">
                                        <i class="bx bx-purchase-tag"></i> {{ $customer->sales_count ?? 0 }} Sales
                                    </span>
                                </div>
                                <div class="d-flex gap-3">
                                    @if($customer->customer_code)
                                        <small class="text-muted">
                                            <i class="bx bx-id-card"></i> Code: {{ $customer->customer_code }}
                                        </small>
                                    @endif
                                    <small class="text-muted">
                                        <i class="bx bx-calendar"></i> Customer Since: {{ $customer->created_at->format('M d, Y') }}
                                    </small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="text-end">
                                    <div class="mb-3">
                                        <div class="h4 mb-1 {{ $salesStats['balance'] > 0 ? 'balance-negative' : 'balance-zero' }}">
                                            KES{{ number_format($salesStats['balance'], 2) }}
                                        </div>
                                        <small class="text-muted">Current Balance</small>
                                    </div>
                                    @if($customer->credit_limit > 0)
                                    <div class="mb-3">
                                        <div class="h5 text-success">KES{{ number_format($salesStats['available_credit'], 2) }}</div>
                                        <small class="text-muted">Available Credit</small>
                                    </div>
                                    @endif
                                    @if($customer->days_since_last_purchase !== null)
                                    <div>
                                        <small class="text-muted">
                                            <i class="bx bx-time"></i> 
                                            {{ $customer->days_since_last_purchase }} days since last purchase
                                        </small>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Left Column: Customer Details -->
            <div class="col-lg-8">
                <!-- Contact Information -->
                <div class="card mb-4">
                    <div class="card-header bg-transparent">
                        <h5 class="mb-0"><i class="bx bx-contact"></i> Contact Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="info-label">Email Address</div>
                                <div class="info-value">
                                    @if($customer->email)
                                        <a href="mailto:{{ $customer->email }}" class="text-primary">
                                            <i class="bx bx-envelope"></i> {{ $customer->email }}
                                        </a>
                                    @else
                                        <span class="text-muted">Not provided</span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="info-label">Phone Number</div>
                                <div class="info-value">
                                    @if($customer->phone)
                                        <a href="tel:{{ $customer->phone }}" class="text-primary">
                                            <i class="bx bx-phone"></i> {{ $customer->phone }}
                                        </a>
                                    @else
                                        <span class="text-muted">Not provided</span>
                                    @endif
                                </div>
                            </div>
                            @if($customer->contact_person)
                            <div class="col-md-6 mb-3">
                                <div class="info-label">Contact Person</div>
                                <div class="info-value">
                                    {{ $customer->contact_person }}
                                </div>
                            </div>
                            @endif
                            @if($customer->website)
                            <div class="col-md-6 mb-3">
                                <div class="info-label">Website</div>
                                <div class="info-value">
                                    <a href="{{ $customer->website }}" target="_blank" class="text-primary">
                                        <i class="bx bx-link-external"></i> {{ $customer->website }}
                                    </a>
                                </div>
                            </div>
                            @endif
                            <div class="col-12 mb-3">
                                <div class="info-label">Address</div>
                                <div class="info-value">
                                    @if($customer->address)
                                        <i class="bx bx-map"></i> {{ $customer->address }}
                                    @else
                                        <span class="text-muted">Address not provided</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Business & VAT Information -->
                @if($customer->customer_type == 'business' || $customer->vat_number || $customer->tax_id || $customer->is_vat_registered)
                <div class="card mb-4">
                    <div class="card-header bg-transparent">
                        <h5 class="mb-0"><i class="bx bx-briefcase"></i> Business & VAT Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @if($customer->vat_number)
                            <div class="col-md-6 mb-3">
                                <div class="info-label">VAT Number</div>
                                <div class="info-value">
                                    {{ $customer->vat_number }}
                                    @if($customer->is_vat_registered)
                                        <span class="badge bg-success ms-2">Valid</span>
                                    @endif
                                </div>
                            </div>
                            @endif
                            @if($customer->tax_id)
                            <div class="col-md-6 mb-3">
                                <div class="info-label">Tax ID</div>
                                <div class="info-value">
                                    {{ $customer->tax_id }}
                                </div>
                            </div>
                            @endif
                            <div class="col-md-6 mb-3">
                                <div class="info-label">Customer Type</div>
                                <div class="info-value">
                                    <span class="badge bg-{{ $customer->customer_type == 'walk-in' ? 'warning text-dark' : ($customer->customer_type == 'regular' ? 'success' : 'primary') }}">
                                        {{ ucfirst($customer->customer_type) }}
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="info-label">Account Status</div>
                                <div class="info-value">
                                    <span class="badge bg-{{ $customer->status == 'active' ? 'success' : 'secondary' }}">
                                        {{ ucfirst($customer->status) }}
                                    </span>
                                </div>
                            </div>
                            @if($customer->is_vat_registered)
                            <div class="col-12">
                                <div class="info-label">VAT Summary</div>
                                <div class="info-value">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="stat-card bg-light">
                                                <small class="text-muted">Taxable Sales</small>
                                                <div class="h6 mb-0">KES{{ number_format($salesStats['taxable_sales'], 2) }}</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="stat-card bg-light">
                                                <small class="text-muted">VAT Collected</small>
                                                <div class="h6 mb-0">KES{{ number_format($salesStats['vat_collected'], 2) }}</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="stat-card bg-light">
                                                <small class="text-muted">Effective Rate</small>
                                                <div class="h6 mb-0">{{ number_format($salesStats['vat_rate_effective'], 2) }}%</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                @endif

                <!-- Notes -->
                @if($customer->notes)
                <div class="card mb-4">
                    <div class="card-header bg-transparent">
                        <h5 class="mb-0"><i class="bx bx-note"></i> Notes</h5>
                    </div>
                    <div class="card-body">
                        <div class="bg-light p-3 rounded">
                            {{ $customer->notes }}
                        </div>
                    </div>
                </div>
                @endif
            </div>

            <!-- Right Column: Statistics & Quick Actions -->
            <div class="col-lg-4">
                <!-- Statistics Card -->
                <div class="card mb-4">
                    <div class="card-header bg-transparent">
                        <h5 class="mb-0"><i class="bx bx-stats"></i> Sales Statistics</h5>
                    </div>
                    <div class="card-body">
                        <div class="row text-center">
                            <div class="col-6 mb-3">
                                <div class="p-3 bg-light-primary rounded">
                                    <h4 class="mb-0 text-primary">{{ $salesStats['total_sales'] }}</h4>
                                    <small class="text-muted">Total Sales</small>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="p-3 bg-light-success rounded">
                                    <h4 class="mb-0 text-success">KES{{ number_format($salesStats['total_spent'], 2) }}</h4>
                                    <small class="text-muted">Total Spent</small>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="p-3 bg-light-info rounded">
                                    <h4 class="mb-0 text-info">KES{{ number_format($salesStats['avg_order_value'], 2) }}</h4>
                                    <small class="text-muted">Avg. Order</small>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="p-3 bg-light-warning rounded">
                                    <h6 class="mb-0 {{ $salesStats['balance'] > 0 ? 'balance-negative' : ($salesStats['balance'] < 0 ? 'balance-positive' : 'balance-zero') }}">
                                        KES{{ number_format(abs($salesStats['balance']), 2) }}
                                    </h6>
                                    <small class="text-muted">Balance</small>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Additional Stats -->
                        <div class="row mt-3">
                            <div class="col-6">
                                <div class="text-center">
                                    <h6 class="mb-0">{{ $customer->loyalty_points }}</h6>
                                    <small class="text-muted">Loyalty Points</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center">
                                    <h6 class="mb-0">{{ $customer->discount_percent }}%</h6>
                                    <small class="text-muted">Discount</small>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Customer Level Progress -->
                        <div class="mt-3">
                            <small class="text-muted d-block mb-2">Customer Level Progress</small>
                            <div class="progress" style="height: 10px;">
                                @php
                                    $levelProgress = 0;
                                    if ($customer->total_spent >= 100000) {
                                        $levelProgress = 100;
                                    } elseif ($customer->total_spent >= 50000) {
                                        $levelProgress = 75;
                                    } elseif ($customer->total_spent >= 10000) {
                                        $levelProgress = 50;
                                    } else {
                                        $levelProgress = ($customer->total_spent / 10000) * 100;
                                    }
                                    $levelProgress = min($levelProgress, 100);
                                @endphp
                                <div class="progress-bar bg-{{ $customer->customer_level == 'platinum' ? 'secondary' : ($customer->customer_level == 'gold' ? 'warning' : ($customer->customer_level == 'silver' ? 'secondary' : 'danger')) }}" 
                                     role="progressbar" style="width: {{ $levelProgress }}%">
                                </div>
                            </div>
                            <small class="text-muted mt-1 d-block">
                                {{ number_format($levelProgress, 1) }}% to next level
                            </small>
                        </div>

                        <!-- Credit Information -->
                        @if($customer->credit_limit)
                        <div class="mt-3 p-3 bg-light rounded">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted">Credit Limit:</span>
                                <strong>KES{{ number_format($customer->credit_limit, 2) }}</strong>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="text-muted">Available Credit:</span>
                                <strong class="text-success">KES{{ number_format($salesStats['available_credit'], 2) }}</strong>
                            </div>
                            <div class="progress mt-2" style="height: 8px;">
                                @php
                                    $creditUsed = $customer->credit_limit > 0 ? ($customer->credit_balance / $customer->credit_limit) * 100 : 0;
                                    $creditUsed = min($creditUsed, 100);
                                @endphp
                                <div class="progress-bar bg-{{ $creditUsed > 80 ? 'danger' : ($creditUsed > 50 ? 'warning' : 'success') }}" 
                                     role="progressbar" style="width: {{ $creditUsed }}%">
                                </div>
                            </div>
                            <small class="text-muted mt-1 d-block">
                                {{ number_format($creditUsed, 1) }}% of credit limit used
                            </small>
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="card mb-4">
                    <div class="card-header bg-transparent">
                        <h5 class="mb-0"><i class="bx bx-rocket"></i> Quick Actions</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="{{ route('pos.index') }}?customer_id={{ $customer->id }}" 
                               class="btn btn-success">
                                <i class="bx bx-cart-add"></i> Create New Sale
                            </a>
                            @if($customer->balance > 0)
                            <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#paymentModal">
                                <i class="bx bx-money"></i> Record Payment
                            </button>
                            @endif
                            <button type="button" class="btn btn-outline-info" id="generateStatementBtn">
                                <i class="bx bx-file"></i> Generate Statement
                            </button>
                            <a href="mailto:{{ $customer->email }}" 
                               class="btn btn-outline-secondary {{ !$customer->email ? 'disabled' : '' }}">
                                <i class="bx bx-envelope"></i> Send Email
                            </a>
                            <a href="tel:{{ $customer->phone }}" 
                               class="btn btn-outline-warning {{ !$customer->phone ? 'disabled' : '' }}">
                                <i class="bx bx-phone"></i> Call Customer
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Recent Activity -->
                <div class="card">
                    <div class="card-header bg-transparent">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5 class="mb-0"><i class="bx bx-history"></i> Recent Activity</h5>
                            <a href="{{ route('sales.index') }}?customer={{ $customer->id }}" class="btn btn-sm btn-link">
                                View All
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($sales->count() > 0)
                            <div class="list-group list-group-flush">
                                @foreach($sales->take(5) as $sale)
                                <a href="{{ route('sales.show', $sale) }}" 
                                   class="list-group-item list-group-item-action sale-card">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h6 class="mb-1">Sale #{{ $sale->invoice_no ?? str_pad($sale->id, 5, '0', STR_PAD_LEFT) }}</h6>
                                        <small class="text-muted">{{ $sale->created_at->format('M d') }}</small>
                                    </div>
                                    <p class="mb-1">KES{{ number_format($sale->grand_total, 2) }}</p>
                                    <small>
                                        <i class="bx bx-credit-card"></i> 
                                        <span class="text-uppercase">{{ $sale->payment_method }}</span>
                                        @if($sale->tax_amount > 0)
                                            <span class="badge bg-purple ms-2">VAT: KES{{ number_format($sale->tax_amount, 2) }}</span>
                                        @endif
                                    </small>
                                </a>
                                @endforeach
                            </div>
                            
                            <div class="mt-3">
                                {{ $sales->links() }}
                            </div>
                        @else
                            <div class="text-center py-3">
                                <i class="bx bx-shopping-bag bx-lg text-muted mb-3"></i>
                                <p class="text-muted mb-0">No sales history</p>
                                <a href="{{ route('pos.index') }}?customer_id={{ $customer->id }}" 
                                   class="btn btn-sm btn-primary mt-2">
                                    <i class="bx bx-plus"></i> Create First Sale
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Payment Modal -->
        @if($customer->balance > 0)
        <div class="modal fade" id="paymentModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Record Payment</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form id="paymentForm" action="{{ route('customers.update-balance', $customer) }}" method="POST">
                        @csrf
                        <div class="modal-body">
                            <div class="mb-3">
                                <label class="form-label">Current Balance</label>
                                <input type="text" class="form-control" value="KES{{ number_format($customer->balance, 2) }}" readonly>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Payment Amount *</label>
                                <div class="input-group">
                                    <span class="input-group-text">KES</span>
                                    <input type="number" class="form-control" name="amount" 
                                           step="0.01" min="0.01" max="{{ $customer->balance }}" 
                                           placeholder="0.00" required>
                                </div>
                                <div class="form-text">Maximum: KES{{ number_format($customer->balance, 2) }}</div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Payment Method</label>
                                <select class="form-select" name="payment_method">
                                    <option value="cash">Cash</option>
                                    <option value="credit_card">Credit Card</option>
                                    <option value="mpesa">M-Pesa</option>
                                    <option value="bank_transfer">Bank Transfer</option>
                                    <option value="check">Check</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Notes</label>
                                <textarea class="form-control" name="notes" rows="2" placeholder="Payment notes..."></textarea>
                            </div>
                            <input type="hidden" name="type" value="payment">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary">Record Payment</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        @endif

        <!-- Statement Generation Modal -->
        <div class="modal fade" id="statementModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Generate Statement</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form id="statementForm" action="{{ route('customers.statement', $customer) }}" method="GET">
                        <div class="modal-body">
                            <div class="mb-3">
                                <label class="form-label">Start Date</label>
                                <input type="date" class="form-control" name="start_date" 
                                       value="{{ date('Y-m-d', strtotime('-1 month')) }}">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">End Date</label>
                                <input type="date" class="form-control" name="end_date" 
                                       value="{{ date('Y-m-d') }}">
                            </div>
                            <div class="alert alert-info">
                                <i class="bx bx-info-circle"></i>
                                This will generate a detailed statement with all sales, payments, and VAT information.
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary">Generate Statement</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Reset Statistics Modal -->
        <div class="modal fade" id="resetStatsModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Reset Customer Statistics</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-warning">
                            <i class="bx bx-error"></i>
                            <strong>Warning:</strong> This action will reset all customer statistics including:
                            <ul class="mt-2 mb-0">
                                <li>Total spent amount (KES{{ number_format($customer->total_spent, 2) }})</li>
                                <li>Total orders ({{ $customer->total_orders }})</li>
                                <li>Taxable sales (KES{{ number_format($customer->taxable_sales, 2) }})</li>
                                <li>VAT collected (KES{{ number_format($customer->vat_collected, 2) }})</li>
                                <li>Loyalty points ({{ $customer->loyalty_points }})</li>
                                <li>Last purchase date</li>
                            </ul>
                        </div>
                        <p class="text-danger">
                            <i class="bx bx-error-circle"></i>
                            This action cannot be undone. Only reset if absolutely necessary.
                        </p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <form action="{{ route('customers.reset-statistics', $customer) }}" method="POST">
                            @csrf
                            <button type="submit" class="btn btn-warning">Reset Statistics</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Delete Customer</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>Are you sure you want to delete customer <strong id="deleteCustomerName"></strong>?</p>
                        <p class="text-danger">
                            <i class="bx bx-error"></i> This action cannot be undone. All customer data will be permanently deleted.
                        </p>
                        <div class="alert alert-warning mt-3">
                            <i class="bx bx-info-circle"></i>
                            <small>
                                Note: Customers with existing sales records cannot be deleted.
                                You must first delete or reassign all sales associated with this customer.
                            </small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <form id="deleteForm" method="POST" style="display: inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">Delete Customer</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script src="{{ asset('assets/plugins/sweetalert/sweetalert2.min.js') }}"></script>
<script>
    $(document).ready(function() {
        // Generate Statement
        $('#generateStatementBtn').click(function(e) {
            e.preventDefault();
            $('#statementModal').modal('show');
        });

        // Statement form submission
        $('#statementForm').submit(function(e) {
            e.preventDefault();
            const formData = $(this).serialize();
            const url = $(this).attr('action') + '?' + formData;
            
            window.open(url, '_blank');
            $('#statementModal').modal('hide');
        });

        // Delete customer confirmation
        $('.delete-customer').click(function(e) {
            e.preventDefault();
            const customerId = $(this).data('id');
            const customerName = $(this).data('name');
            
            $('#deleteCustomerName').text(customerName);
            $('#deleteForm').attr('action', `/customers/${customerId}`);
            
            // Check if customer has sales
            $.ajax({
                url: `/api/customers/${customerId}/has-sales`,
                type: 'GET',
                success: function(response) {
                    if (response.success && response.has_sales) {
                        Swal.fire({
                            title: 'Cannot Delete Customer',
                            text: 'This customer has ' + response.sales_count + ' sales records. Please delete or reassign all sales first.',
                            icon: 'error',
                            confirmButtonColor: '#3085d6',
                        });
                    } else {
                        $('#deleteModal').modal('show');
                    }
                },
                error: function() {
                    $('#deleteModal').modal('show');
                }
            });
        });

        // Payment form validation
        $('#paymentForm').validate({
            rules: {
                amount: {
                    required: true,
                    number: true,
                    min: 0.01,
                    max: {{ $customer->balance }}
                }
            },
            messages: {
                amount: {
                    required: "Please enter payment amount",
                    min: "Payment amount must be at least KES0.01",
                    max: "Payment amount cannot exceed balance"
                }
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.mb-3').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
            submitHandler: function(form) {
                $.ajax({
                    url: $(form).attr('action'),
                    type: 'POST',
                    data: $(form).serialize(),
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                title: 'Payment Recorded!',
                                text: response.message,
                                icon: 'success',
                                confirmButtonColor: '#3085d6',
                            }).then(() => {
                                location.reload();
                            });
                        }
                    },
                    error: function(xhr) {
                        let message = 'Failed to record payment.';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            message = xhr.responseJSON.message;
                        }
                        Swal.fire({
                            title: 'Error!',
                            text: message,
                            icon: 'error',
                            confirmButtonColor: '#3085d6',
                        });
                    }
                });
                return false;
            }
        });

        // Copy customer email
        $('[data-action="copy-email"]').click(function() {
            const email = '{{ $customer->email }}';
            if (email) {
                navigator.clipboard.writeText(email).then(() => {
                    Swal.fire({
                        title: 'Copied!',
                        text: 'Email address copied to clipboard.',
                        icon: 'success',
                        timer: 1500,
                        showConfirmButton: false
                    });
                });
            }
        });

        // Initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>
@endsection