@extends('layouts.app')

@section('style')
    <link href="{{ asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet" />
    <link href="{{ asset('assets/plugins/sweetalert/sweetalert2.min.css') }}" rel="stylesheet" />
    <style>
        .customer-card {
            transition: transform 0.2s;
        }
        .customer-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .customer-type-badge {
            font-size: 0.7rem;
            padding: 0.2rem 0.5rem;
        }
        .customer-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            margin-right: 10px;
        }
        .balance-positive { color: #198754; }
        .balance-negative { color: #dc3545; }
        .balance-zero { color: #6c757d; }
        .vat-badge {
            font-size: 0.65rem;
            padding: 0.15rem 0.4rem;
        }
        .loyalty-badge {
            background: linear-gradient(45deg, #FFD700, #FFA500);
            color: #000;
        }
    </style>
@endsection

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Customers</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">Customers</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="{{ route('customers.create') }}" class="btn btn-primary">
                        <i class="bx bx-plus"></i> Add New Customer
                    </a>
                    <button type="button" class="btn btn-primary split-bg-primary dropdown-toggle dropdown-toggle-split" 
                            data-bs-toggle="dropdown">
                        <span class="visually-hidden">Toggle Dropdown</span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end">
                        <a class="dropdown-item" href="{{ route('customers.export') }}">
                            <i class="bx bx-download"></i> Export to CSV
                        </a>
                        <a class="dropdown-item" href="{{ route('customers.export.vat') }}">
                            <i class="bx bx-receipt"></i> Export VAT Report
                        </a>
                        <a class="dropdown-item" href="{{ route('customers.vat-report') }}">
                            <i class="bx bx-file"></i> VAT Report
                        </a>
                        <a class="dropdown-item" href="#" id="bulkDeleteBtn">
                            <i class="bx bx-trash"></i> Bulk Delete
                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="#" onclick="window.print()">
                            <i class="bx bx-printer"></i> Print List
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Statistics Cards -->
        <div class="row row-cols-1 row-cols-md-4 row-cols-xl-4 mb-4">
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-info">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Total Customers</p>
                                <h4 class="my-1 text-info">{{ number_format($stats['total'] ?? 0) }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-scooter text-white ms-auto">
                                <i class='bx bxs-group'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-success">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Regular Customers</p>
                                <h4 class="my-1 text-success">{{ number_format($stats['regular'] ?? 0) }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-ohhappiness text-white ms-auto">
                                <i class='bx bxs-user-check'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-warning">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Walk-in Customers</p>
                                <h4 class="my-1 text-warning">{{ number_format($stats['walk_in'] ?? 0) }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-burning text-white ms-auto">
                                <i class='bx bxs-user'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-danger">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Total Revenue</p>
                                <h4 class="my-1 text-danger">KES{{ number_format($stats['total_revenue'] ?? 0, 2) }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-bloody text-white ms-auto">
                                <i class='bx bxs-dollar-circle'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Statistics -->
        <div class="row row-cols-1 row-cols-md-4 row-cols-xl-4 mb-4">
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-primary">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Business Customers</p>
                                <h4 class="my-1 text-primary">{{ number_format($stats['business'] ?? 0) }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-moonlit text-white ms-auto">
                                <i class='bx bx-building'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-purple">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">VAT Registered</p>
                                <h4 class="my-1 text-purple">{{ number_format($stats['vat_registered'] ?? 0) }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-purple text-white ms-auto">
                                <i class='bx bx-receipt'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-orange">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Total VAT Collected</p>
                                <h4 class="my-1 text-orange">KES{{ number_format($stats['total_vat_collected'] ?? 0, 2) }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-orange text-white ms-auto">
                                <i class='bx bx-money'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-teal">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Loyalty Points</p>
                                <h4 class="my-1 text-teal">{{ number_format($stats['total_loyalty_points'] ?? 0) }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-teal text-white ms-auto">
                                <i class='bx bx-gift'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Search and Filter -->
        <div class="card mb-4">
            <div class="card-body">
                <form method="GET" action="{{ route('customers.index') }}" id="searchForm">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <div class="input-group">
                                <input type="text" class="form-control" name="search" 
                                       placeholder="Search by name, email, phone, VAT..." 
                                       value="{{ request('search') }}">
                                <button class="btn btn-outline-secondary" type="submit">
                                    <i class="bx bx-search"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" name="type" onchange="document.getElementById('searchForm').submit()">
                                <option value="">All Customers</option>
                                <option value="walk-in" {{ request('type') == 'walk-in' ? 'selected' : '' }}>
                                    Walk-in Customers
                                </option>
                                <option value="regular" {{ request('type') == 'regular' ? 'selected' : '' }}>
                                    Regular Customers
                                </option>
                                <option value="business" {{ request('type') == 'business' ? 'selected' : '' }}>
                                    Business Customers
                                </option>
                                <option value="active" {{ request('type') == 'active' ? 'selected' : '' }}>
                                    Active Customers
                                </option>
                                <option value="with-balance" {{ request('type') == 'with-balance' ? 'selected' : '' }}>
                                    With Balance
                                </option>
                                <option value="vat-registered" {{ request('type') == 'vat-registered' ? 'selected' : '' }}>
                                    VAT Registered
                                </option>
                                <option value="non-vat" {{ request('type') == 'non-vat' ? 'selected' : '' }}>
                                    Non-VAT
                                </option>
                                <option value="has-credit" {{ request('type') == 'has-credit' ? 'selected' : '' }}>
                                    Has Credit Limit
                                </option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" name="sort_by" onchange="document.getElementById('searchForm').submit()">
                                <option value="created_at" {{ request('sort_by') == 'created_at' ? 'selected' : '' }}>
                                    Sort by Date
                                </option>
                                <option value="name" {{ request('sort_by') == 'name' ? 'selected' : '' }}>
                                    Sort by Name
                                </option>
                                <option value="total_spent" {{ request('sort_by') == 'total_spent' ? 'selected' : '' }}>
                                    Sort by Total Spent
                                </option>
                                <option value="vat_collected" {{ request('sort_by') == 'vat_collected' ? 'selected' : '' }}>
                                    Sort by VAT Collected
                                </option>
                                <option value="last_purchase_date" {{ request('sort_by') == 'last_purchase_date' ? 'selected' : '' }}>
                                    Sort by Last Purchase
                                </option>
                                <option value="credit_balance" {{ request('sort_by') == 'credit_balance' ? 'selected' : '' }}>
                                    Sort by Credit Balance
                                </option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <a href="{{ route('customers.index') }}" class="btn btn-outline-secondary w-100">
                                <i class="bx bx-refresh"></i> Reset
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Main Content -->
        <div class="card">
            <div class="card-body">
                @if(session('success'))
                    <div class="alert alert-success border-0 bg-success alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-white">
                                <i class="bx bxs-check-circle"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-white">Success</h6>
                                <div class="text-white">{{ session('success') }}</div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger border-0 bg-danger alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-white">
                                <i class="bx bxs-message-square-x"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-white">Error</h6>
                                <div class="text-white">{{ session('error') }}</div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if($errors->any())
                    <div class="alert alert-danger border-0 bg-danger alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-white">
                                <i class="bx bxs-error"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-white">Validation Errors</h6>
                                <ul class="text-white mb-0">
                                    @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if($customers->count() > 0)
                    <div class="table-responsive">
                        <table id="customersTable" class="table table-striped table-bordered" style="width:100%">
                            <thead class="table-light">
                                <tr>
                                    <th width="50">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="selectAll">
                                        </div>
                                    </th>
                                    <th>Customer</th>
                                    <th>Contact</th>
                                    <th>Type/Status</th>
                                    <th>Sales Statistics</th>
                                    <th>Credit/Balance</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($customers as $customer)
                                <tr>
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input select-item" type="checkbox" 
                                                   value="{{ $customer->id }}">
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="customer-avatar" 
                                                 style="background: {{ $customer->customer_type == 'walk-in' ? '#ffc107' : ($customer->customer_type == 'business' ? '#0d6efd' : '#198754') }}">
                                                {{ strtoupper(substr($customer->name, 0, 1)) }}
                                            </div>
                                            <div>
                                                <h6 class="mb-1 font-14">{{ $customer->name }}</h6>
                                                <p class="mb-0 font-12 text-muted">
                                                    @if($customer->company_name)
                                                        <i class="bx bx-building"></i> {{ $customer->company_name }}
                                                    @else
                                                        <i class="bx bx-id-card"></i> {{ $customer->customer_code }}
                                                    @endif
                                                </p>
                                                <p class="mb-0 font-11 text-muted">
                                                    @if($customer->email)
                                                        <i class="bx bx-envelope"></i> {{ $customer->email }}
                                                    @endif
                                                </p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div>
                                            @if($customer->phone)
                                                <div class="mb-1">
                                                    <i class="bx bx-phone"></i> {{ $customer->phone }}
                                                </div>
                                            @endif
                                            @if($customer->vat_number)
                                                <div class="font-12 text-muted">
                                                    <i class="bx bx-receipt"></i> VAT: {{ $customer->vat_number }}
                                                </div>
                                            @endif
                                            @if($customer->contact_person)
                                                <div class="font-12 text-muted">
                                                    <i class="bx bx-user"></i> {{ $customer->contact_person }}
                                                </div>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <div class="mb-1">
                                            @if($customer->customer_type == 'walk-in')
                                                <span class="badge bg-warning text-dark customer-type-badge">
                                                    <i class="bx bx-walk"></i> Walk-in
                                                </span>
                                            @elseif($customer->customer_type == 'regular')
                                                <span class="badge bg-success customer-type-badge">
                                                    <i class="bx bx-user"></i> Regular
                                                </span>
                                            @else
                                                <span class="badge bg-primary customer-type-badge">
                                                    <i class="bx bx-building"></i> Business
                                                </span>
                                            @endif
                                        </div>
                                        <div class="mb-1">
                                            @if($customer->status == 'active')
                                                <span class="badge bg-light-success text-success status-badge">
                                                    <i class="bx bx-check-circle"></i> Active
                                                </span>
                                            @else
                                                <span class="badge bg-light-secondary text-secondary status-badge">
                                                    <i class="bx bx-time"></i> Inactive
                                                </span>
                                            @endif
                                        </div>
                                        <div>
                                            @if($customer->is_vat_registered)
                                                <span class="badge bg-purple vat-badge">
                                                    <i class="bx bx-check"></i> VAT Registered
                                                </span>
                                            @endif
                                            @if($customer->loyalty_points > 0)
                                                <span class="badge loyalty-badge vat-badge">
                                                    <i class="bx bx-gift"></i> {{ $customer->loyalty_points }} pts
                                                </span>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <div class="mb-1">
                                                <strong>KES{{ number_format($customer->total_spent, 2) }}</strong>
                                                <small class="text-muted">total spent</small>
                                            </div>
                                            <div class="mb-1">
                                                <small class="text-muted">
                                                    <i class="bx bx-shopping-bag"></i> {{ $customer->total_orders }} orders
                                                    @if($customer->total_orders > 0)
                                                        (KES{{ number_format($customer->average_order_value, 2) }} avg)
                                                    @endif
                                                </small>
                                            </div>
                                            <div class="mb-1">
                                                <small class="text-muted">
                                                    <i class="bx bx-calendar"></i> 
                                                    @if($customer->last_purchase_date)
                                                        Last: {{ $customer->last_purchase_date->format('M d, Y') }}
                                                    @else
                                                        Never purchased
                                                    @endif
                                                </small>
                                            </div>
                                            @if($customer->taxable_sales > 0)
                                            <div>
                                                <small class="text-muted">
                                                    <i class="bx bx-receipt"></i> 
                                                    VAT: KES{{ number_format($customer->vat_collected, 2) }}
                                                    ({{ number_format($customer->vat_rate_effective, 1) }}%)
                                                </small>
                                            </div>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            @if($customer->credit_limit > 0)
                                                <div class="mb-1">
                                                    <strong class="{{ $customer->balance > 0 ? 'balance-negative' : 'balance-zero' }}">
                                                        <i class="bx bx-credit-card"></i> KES{{ number_format($customer->balance, 2) }}
                                                    </strong>
                                                    <small class="text-muted d-block">Balance</small>
                                                </div>
                                                <div class="mb-1">
                                                    <small class="text-muted">
                                                        Limit: KES{{ number_format($customer->credit_limit, 2) }}
                                                    </small>
                                                </div>
                                                <div>
                                                    <small class="text-muted">
                                                        Available: <span class="text-success">KES{{ number_format($customer->available_credit, 2) }}</span>
                                                    </small>
                                                </div>
                                            @else
                                                <div class="mb-1">
                                                    <span class="balance-zero">
                                                        <i class="bx bx-check"></i> KES 0.00
                                                    </span>
                                                    <small class="text-muted d-block">No Credit</small>
                                                </div>
                                            @endif
                                            @if($customer->discount_percent > 0)
                                                <div class="mt-1">
                                                    <small class="text-success">
                                                        <i class="bx bx-discount"></i> {{ $customer->discount_percent }}% Discount
                                                    </small>
                                                </div>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex order-actions">
                                            <a href="{{ route('customers.show', $customer) }}" 
                                               class="btn btn-sm btn-outline-info" 
                                               data-bs-toggle="tooltip" 
                                               title="View Details">
                                                <i class="bx bx-show"></i>
                                            </a>
                                            <a href="{{ route('customers.edit', $customer) }}" 
                                               class="btn btn-sm btn-outline-primary ms-2"
                                               data-bs-toggle="tooltip"
                                               title="Edit">
                                                <i class="bx bx-edit"></i>
                                            </a>
                                            <a href="{{ route('pos.index') }}?customer_id={{ $customer->id }}" 
                                               class="btn btn-sm btn-outline-success ms-2"
                                               data-bs-toggle="tooltip"
                                               title="New Sale">
                                                <i class="bx bx-cart-add"></i>
                                            </a>
                                            <form action="{{ route('customers.destroy', $customer) }}" 
                                                  method="POST" 
                                                  class="ms-2 delete-form">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button" 
                                                        class="btn btn-sm btn-outline-danger delete-btn"
                                                        data-bs-toggle="tooltip"
                                                        title="Delete">
                                                    <i class="bx bx-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div>
                            Showing {{ $customers->firstItem() }} to {{ $customers->lastItem() }} 
                            of {{ $customers->total() }} entries
                        </div>
                        <div>
                            {{ $customers->links() }}
                        </div>
                    </div>
                @else
                    <div class="text-center py-5">
                        <div class="mb-3">
                            <i class="bx bx-user bx-lg text-muted"></i>
                        </div>
                        <h5 class="text-muted">No customers found</h5>
                        <p class="text-muted mb-4">
                            @if(request()->has('search') || request()->has('type'))
                                Try changing your search criteria
                            @else
                                Get started by adding your first customer
                            @endif
                        </p>
                        <a href="{{ route('customers.create') }}" class="btn btn-primary">
                            <i class="bx bx-plus"></i> Add New Customer
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
    <script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/sweetalert/sweetalert2.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            // Initialize DataTable
            $('#customersTable').DataTable({
                paging: false, // We use Laravel pagination
                searching: false, // We use custom search
                info: false,
                order: [],
                columnDefs: [
                    { orderable: false, targets: [0, 6] }
                ],
                language: {
                    emptyTable: "No customers found"
                }
            });

            // Initialize tooltips
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });

            // Select all functionality
            $('#selectAll').change(function() {
                $('.select-item').prop('checked', this.checked);
            });

            // Delete confirmation
            $('.delete-btn').click(function(e) {
                e.preventDefault();
                var form = $(this).closest('form');
                
                Swal.fire({
                    title: 'Are you sure?',
                    text: "This customer will be permanently deleted!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // First check if customer has sales
                        var customerId = form.find('input[name="_method"]').siblings('input[type="hidden"]').val() || 
                                       form.attr('action').split('/').pop();
                        
                        $.ajax({
                            url: '/api/customers/' + customerId + '/has-sales',
                            type: 'GET',
                            success: function(response) {
                                if (response.success && response.has_sales) {
                                    Swal.fire({
                                        title: 'Cannot Delete',
                                        text: 'This customer has ' + response.sales_count + ' sales records. Please delete or reassign sales first.',
                                        icon: 'error',
                                        confirmButtonColor: '#3085d6',
                                    });
                                } else {
                                    form.submit();
                                }
                            },
                            error: function() {
                                form.submit();
                            }
                        });
                    }
                });
            });

            // Bulk delete
            $('#bulkDeleteBtn').click(function(e) {
                e.preventDefault();
                var selectedIds = [];
                $('.select-item:checked').each(function() {
                    selectedIds.push($(this).val());
                });
                
                if (selectedIds.length === 0) {
                    Swal.fire({
                        title: 'No Selection',
                        text: 'Please select at least one customer to delete.',
                        icon: 'warning',
                        confirmButtonColor: '#3085d6',
                    });
                    return;
                }
                
                Swal.fire({
                    title: 'Delete Selected Customers?',
                    text: "You are about to delete " + selectedIds.length + " customer(s). This action cannot be undone!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete them!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: '{{ route("customers.bulk-delete") }}',
                            type: 'POST',
                            data: {
                                _token: '{{ csrf_token() }}',
                                ids: selectedIds
                            },
                            success: function(response) {
                                if (response.success) {
                                    Swal.fire({
                                        title: 'Deleted!',
                                        text: response.message,
                                        icon: 'success',
                                        confirmButtonColor: '#3085d6',
                                    }).then(() => {
                                        location.reload();
                                    });
                                } else {
                                    Swal.fire({
                                        title: 'Error!',
                                        text: response.message,
                                        icon: 'error',
                                        confirmButtonColor: '#3085d6',
                                    });
                                }
                            },
                            error: function() {
                                Swal.fire({
                                    title: 'Error!',
                                    text: 'An error occurred while deleting customers.',
                                    icon: 'error',
                                    confirmButtonColor: '#3085d6',
                                });
                            }
                        });
                    }
                });
            });

            // Quick search with debounce
            var searchTimer;
            $('input[name="search"]').on('keyup', function() {
                clearTimeout(searchTimer);
                searchTimer = setTimeout(function() {
                    $('#searchForm').submit();
                }, 500);
            });
        });
    </script>
@endsection