@extends('layouts.app')

@section('style')
    <style>
        .form-section {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        .form-section h6 {
            color: #495057;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #dee2e6;
        }
        .required-field::after {
            content: " *";
            color: #dc3545;
        }
        .vat-section {
            border-left: 4px solid #28a745;
            background: #f0fff4;
        }
        .exemption-section {
            border-left: 4px solid #ffc107;
            background: #fffdf0;
        }
    </style>
@endsection

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Customers</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('customers.index') }}">Customers</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Create New Customer</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <a href="{{ route('customers.index') }}" class="btn btn-outline-secondary">
                    <i class="bx bx-arrow-back"></i> Back to List
                </a>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title mb-4">Create New Customer</h5>
                        
                        @if($errors->any())
                            <div class="alert alert-danger border-0 bg-danger alert-dismissible fade show py-2">
                                <div class="d-flex align-items-center">
                                    <div class="font-35 text-white">
                                        <i class="bx bxs-error"></i>
                                    </div>
                                    <div class="ms-3">
                                        <h6 class="mb-0 text-white">Please fix the following errors:</h6>
                                        <ul class="text-white mb-0">
                                            @foreach($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        @endif

                        <form method="POST" action="{{ route('customers.store') }}" id="customerForm">
                            @csrf
                            
                            <!-- Basic Information -->
                            <div class="form-section">
                                <h6><i class="bx bx-info-circle"></i> Basic Information</h6>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="name" class="form-label required-field">Full Name</label>
                                        <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                               id="name" name="name" value="{{ old('name') }}" 
                                               placeholder="Enter customer name" required>
                                        @error('name')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label for="customer_type" class="form-label">Customer Type</label>
                                        <select class="form-select @error('customer_type') is-invalid @enderror" 
                                                id="customer_type" name="customer_type">
                                            <option value="regular" {{ old('customer_type') == 'regular' ? 'selected' : '' }}>Regular Customer</option>
                                            <option value="business" {{ old('customer_type') == 'business' ? 'selected' : '' }}>Business Customer</option>
                                            <option value="walk-in" {{ old('customer_type') == 'walk-in' ? 'selected' : '' }}>Walk-in Customer</option>
                                        </select>
                                        @error('customer_type')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label for="company_name" class="form-label">Company Name</label>
                                        <input type="text" class="form-control @error('company_name') is-invalid @enderror" 
                                               id="company_name" name="company_name" value="{{ old('company_name') }}"
                                               placeholder="Enter company name">
                                        @error('company_name')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label for="contact_person" class="form-label">Contact Person</label>
                                        <input type="text" class="form-control @error('contact_person') is-invalid @enderror" 
                                               id="contact_person" name="contact_person" value="{{ old('contact_person') }}"
                                               placeholder="Primary contact person">
                                        @error('contact_person')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <!-- Contact Information -->
                            <div class="form-section">
                                <h6><i class="bx bx-phone"></i> Contact Information</h6>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="email" class="form-label">Email Address</label>
                                        <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                               id="email" name="email" value="{{ old('email') }}"
                                               placeholder="customer@example.com">
                                        @error('email')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label for="phone" class="form-label required-field">Phone Number</label>
                                        <input type="text" class="form-control @error('phone') is-invalid @enderror" 
                                               id="phone" name="phone" value="{{ old('phone') }}"
                                               placeholder="+254 700 123 456" required>
                                        @error('phone')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-12 mb-3">
                                        <label for="address" class="form-label">Address</label>
                                        <textarea class="form-control @error('address') is-invalid @enderror" 
                                                  id="address" name="address" rows="3" 
                                                  placeholder="Full address">{{ old('address') }}</textarea>
                                        @error('address')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <!-- VAT Registration Information -->
                            <div class="form-section vat-section">
                                <h6><i class="bx bx-receipt"></i> VAT Registration Information</h6>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="vat_number" class="form-label">VAT Number</label>
                                        <input type="text" class="form-control @error('vat_number') is-invalid @enderror" 
                                               id="vat_number" name="vat_number" value="{{ old('vat_number') }}"
                                               placeholder="VAT-123456789">
                                        @error('vat_number')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label for="is_vat_registered" class="form-label d-block">VAT Registered</label>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="checkbox" id="is_vat_registered" 
                                                   name="is_vat_registered" value="1" 
                                                   {{ old('is_vat_registered') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="is_vat_registered">
                                                This customer is VAT registered
                                            </label>
                                        </div>
                                        @error('is_vat_registered')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label for="tax_id" class="form-label">Tax ID / PIN</label>
                                        <input type="text" class="form-control @error('tax_id') is-invalid @enderror" 
                                               id="tax_id" name="tax_id" value="{{ old('tax_id') }}"
                                               placeholder="A123456789X">
                                        @error('tax_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label for="website" class="form-label">Website</label>
                                        <input type="url" class="form-control @error('website') is-invalid @enderror" 
                                               id="website" name="website" value="{{ old('website') }}"
                                               placeholder="https://example.com">
                                        @error('website')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label for="vat_status" class="form-label">VAT Status</label>
                                        <select class="form-select @error('vat_status') is-invalid @enderror" 
                                                id="vat_status" name="vat_status">
                                            <option value="vatable" {{ old('vat_status') == 'vatable' ? 'selected' : 'selected' }}>VATable (Standard 16%)</option>
                                            <option value="exempted" {{ old('vat_status') == 'exempted' ? 'selected' : '' }}>VAT Exempted</option>
                                            <option value="zero_rated" {{ old('vat_status') == 'zero_rated' ? 'selected' : '' }}>Zero Rated (0%)</option>
                                        </select>
                                        @error('vat_status')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <!-- Account Settings -->
                            <div class="form-section">
                                <h6><i class="bx bx-cog"></i> Account Settings</h6>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="status" class="form-label">Status</label>
                                        <select class="form-select @error('status') is-invalid @enderror" 
                                                id="status" name="status">
                                            <option value="active" {{ old('status') == 'active' ? 'selected' : 'selected' }}>Active</option>
                                            <option value="inactive" {{ old('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                        </select>
                                        @error('status')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label for="credit_limit" class="form-label">Credit Limit</label>
                                        <div class="input-group">
                                            <span class="input-group-text">KES</span>
                                            <input type="number" class="form-control @error('credit_limit') is-invalid @enderror" 
                                                   id="credit_limit" name="credit_limit" value="{{ old('credit_limit', 0) }}"
                                                   placeholder="0.00" step="0.01" min="0">
                                        </div>
                                        @error('credit_limit')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label for="discount_percent" class="form-label">Discount Percentage</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control @error('discount_percent') is-invalid @enderror" 
                                                   id="discount_percent" name="discount_percent" value="{{ old('discount_percent', 0) }}"
                                                   placeholder="0.00" step="0.01" min="0" max="100">
                                            <span class="input-group-text">%</span>
                                        </div>
                                        @error('discount_percent')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <!-- Additional Notes -->
                            <div class="form-section">
                                <h6><i class="bx bx-note"></i> Additional Information</h6>
                                <div class="row">
                                    <div class="col-12 mb-3">
                                        <label for="notes" class="form-label">Notes</label>
                                        <textarea class="form-control @error('notes') is-invalid @enderror" 
                                                  id="notes" name="notes" rows="4" 
                                                  placeholder="Any additional information about this customer...">{{ old('notes') }}</textarea>
                                        @error('notes')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <!-- Form Actions -->
                            <div class="row mt-4">
                                <div class="col-12">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <button type="submit" class="btn btn-primary px-5">
                                                <i class="bx bx-save"></i> Create Customer
                                            </button>
                                            <button type="reset" class="btn btn-outline-secondary px-5">
                                                <i class="bx bx-reset"></i> Reset Form
                                            </button>
                                        </div>
                                        <div>
                                            <a href="{{ route('customers.index') }}" class="btn btn-outline-info px-4">
                                                <i class="bx bx-list-ul"></i> View All Customers
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    $(document).ready(function() {
        // Form validation
        $('#customerForm').validate({
            rules: {
                name: {
                    required: true,
                    minlength: 2,
                    maxlength: 255
                },
                phone: {
                    required: true,
                    maxlength: 20
                },
                email: {
                    email: true
                },
                website: {
                    url: true
                },
                vat_number: {
                    maxlength: 50
                },
                tax_id: {
                    maxlength: 50
                },
                credit_limit: {
                    min: 0
                },
                discount_percent: {
                    min: 0,
                    max: 100
                }
            },
            messages: {
                name: {
                    required: "Customer name is required",
                    minlength: "Customer name must be at least 2 characters"
                },
                phone: {
                    required: "Phone number is required"
                },
                email: {
                    email: "Please enter a valid email address"
                },
                website: {
                    url: "Please enter a valid website URL"
                }
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.mb-3').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });

        // Phone number formatting
        $('#phone').on('input', function() {
            $(this).val($(this).val().replace(/[^0-9+()\- ]/g, ''));
        });

        // Auto-check VAT registered if VAT number is entered
        $('#vat_number').on('blur', function() {
            if ($(this).val().trim() !== '') {
                $('#is_vat_registered').prop('checked', true);
            }
        });

        // Show exemption fields if needed
        $('#vat_status').change(function() {
            const status = $(this).val();
            if (status === 'exempted' || status === 'zero_rated') {
                if (!confirm('This customer will require additional exemption documentation. Do you want to proceed?')) {
                    $(this).val('vatable');
                }
            }
        });
    });
</script>
@endsection