@extends('layouts.app')

@section('style')
    <style>
        .category-card {
            border-left: 5px solid;
            border-radius: 10px;
            margin-bottom: 20px;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }
        .category-color {
            width: 30px;
            height: 30px;
            border-radius: 5px;
            display: inline-block;
            border: 2px solid #dee2e6;
            margin-right: 10px;
            vertical-align: middle;
        }
        .category-image {
            width: 200px;
            height: 200px;
            object-fit: cover;
            border-radius: 10px;
            border: 3px solid #dee2e6;
        }
        .info-label {
            font-weight: 600;
            color: #495057;
            min-width: 150px;
        }
        .info-value {
            color: #212529;
        }
        .badge-lg {
            font-size: 0.9em;
            padding: 0.5em 0.8em;
        }
        .section-title {
            color: #495057;
            border-bottom: 2px solid #dee2e6;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .no-image {
            width: 200px;
            height: 200px;
            background: #f8f9fa;
            border-radius: 10px;
            border: 2px dashed #dee2e6;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6c757d;
        }
        .children-category {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 10px;
            margin-bottom: 10px;
            border-left: 3px solid;
        }
        .meta-badge {
            font-size: 0.8em;
            padding: 0.3em 0.6em;
            background: #e9ecef;
            color: #495057;
            border-radius: 5px;
        }
    </style>
@endsection

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Categories</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('categories.index') }}">Categories</a></li>
                        <li class="breadcrumb-item active" aria-current="page">View Category</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group" role="group">
                    <a href="{{ route('categories.edit', $category->id) }}" class="btn btn-primary">
                        <i class="bx bx-edit"></i> Edit Category
                    </a>
                    <a href="{{ route('categories.index') }}" class="btn btn-outline-secondary">
                        <i class="bx bx-list-ul"></i> All Categories
                    </a>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="row">
            <div class="col-12">
                <!-- Category Header -->
                <div class="card category-card" style="border-left-color: {{ $category->color ?? '#667eea' }}">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h4 class="card-title mb-1">
                                    <span class="category-color" style="background: {{ $category->color ?? '#667eea' }}"></span>
                                    {{ $category->name }}
                                </h4>
                                <p class="text-muted mb-0">
                                    ID: {{ $category->id }} | 
                                    Created: {{ $category->created_at->format('M d, Y') }} |
                                    Updated: {{ $category->updated_at->format('M d, Y') }}
                                </p>
                            </div>
                            <div class="col-md-4 text-end">
                                <div class="btn-group">
                                    <span class="badge {{ $category->is_active ? 'bg-success' : 'bg-secondary' }} badge-lg">
                                        <i class="bx bx-{{ $category->is_active ? 'check' : 'x' }}-circle"></i>
                                        {{ $category->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                    @if($category->parent)
                                        <span class="badge bg-info badge-lg ms-2">
                                            <i class="bx bx-subdirectory-right"></i> Child Category
                                        </span>
                                    @else
                                        <span class="badge bg-primary badge-lg ms-2">
                                            <i class="bx bx-category"></i> Main Category
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <!-- Left Column: Category Details -->
                    <div class="col-lg-8">
                        <!-- Basic Information Card -->
                        <div class="card mb-4">
                            <div class="card-body">
                                <h5 class="section-title">
                                    <i class="bx bx-info-circle"></i> Basic Information
                                </h5>
                                
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="d-flex mb-3">
                                            <span class="info-label">Category Name:</span>
                                            <span class="info-value ms-2">{{ $category->name }}</span>
                                        </div>
                                        <div class="d-flex mb-3">
                                            <span class="info-label">Parent Category:</span>
                                            <span class="info-value ms-2">
                                                @if($category->parent)
                                                    <a href="{{ route('categories.show', $category->parent->id) }}" 
                                                       class="text-decoration-none">
                                                        <i class="bx bx-folder-open"></i> {{ $category->parent->name }}
                                                    </a>
                                                @else
                                                    <span class="text-muted">None (Main Category)</span>
                                                @endif
                                            </span>
                                        </div>
                                        <div class="d-flex mb-3">
                                            <span class="info-label">Sort Order:</span>
                                            <span class="info-value ms-2">
                                                {{ $category->sort_order }}
                                                <span class="meta-badge ms-2">Lower = First</span>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex mb-3">
                                            <span class="info-label">Color:</span>
                                            <span class="info-value ms-2">
                                                <div class="category-color" style="background: {{ $category->color ?? '#667eea' }}"></div>
                                                <code>{{ $category->color ?? '#667eea' }}</code>
                                            </span>
                                        </div>
                                        <div class="d-flex mb-3">
                                            <span class="info-label">Status:</span>
                                            <span class="info-value ms-2">
                                                @if($category->is_active)
                                                    <span class="badge bg-success">Active</span>
                                                @else
                                                    <span class="badge bg-secondary">Inactive</span>
                                                @endif
                                            </span>
                                        </div>
                                        <div class="d-flex mb-3">
                                            <span class="info-label">Slug:</span>
                                            <span class="info-value ms-2">
                                                <code>{{ $category->slug ?? 'Not set' }}</code>
                                            </span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Description -->
                                @if($category->description)
                                    <div class="mt-4">
                                        <h6><i class="bx bx-detail"></i> Description</h6>
                                        <div class="card bg-light">
                                            <div class="card-body">
                                                <p class="mb-0">{{ $category->description }}</p>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>

                        <!-- Child Categories (if any) -->
                        @if($category->children->count() > 0)
                            <div class="card mb-4">
                                <div class="card-body">
                                    <h5 class="section-title">
                                        <i class="bx bx-subdirectory-right"></i> Child Categories ({{ $category->children->count() }})
                                    </h5>
                                    
                                    <div class="row">
                                        @foreach($category->children as $child)
                                            <div class="col-md-6 mb-3">
                                                <div class="children-category" style="border-left-color: {{ $child->color ?? '#667eea' }}">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div>
                                                            <h6 class="mb-1">
                                                                <a href="{{ route('categories.show', $child->id) }}" 
                                                                   class="text-decoration-none">
                                                                    {{ $child->name }}
                                                                </a>
                                                            </h6>
                                                            <p class="text-muted mb-0 small">
                                                                {{ $child->description ? Str::limit($child->description, 50) : 'No description' }}
                                                            </p>
                                                        </div>
                                                        <div class="text-end">
                                                            <span class="badge {{ $child->is_active ? 'bg-success' : 'bg-secondary' }}">
                                                                {{ $child->is_active ? 'Active' : 'Inactive' }}
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="mt-2">
                                                        <small class="text-muted">
                                                            <i class="bx bx-sort"></i> Order: {{ $child->sort_order }} |
                                                            <i class="bx bx-calendar"></i> Created: {{ $child->created_at->format('M d, Y') }}
                                                        </small>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>

                    <!-- Right Column: Image & Actions -->
                    <div class="col-lg-4">
                        <!-- Category Image -->
                        <div class="card mb-4">
                            <div class="card-body">
                                <h5 class="section-title">
                                    <i class="bx bx-image"></i> Category Image
                                </h5>
                                
                                <div class="text-center">
                                    @if($category->image)
                                        <img src="{{ asset('storage/' . $category->image) }}" 
                                             alt="{{ $category->name }}" 
                                             class="category-image mb-3">
                                        <div class="mt-2">
                                            <a href="{{ asset('storage/' . $category->image) }}" 
                                               target="_blank" 
                                               class="btn btn-sm btn-outline-primary">
                                                <i class="bx bx-zoom-in"></i> View Full Size
                                            </a>
                                        </div>
                                    @else
                                        <div class="no-image mb-3">
                                            <div class="text-center">
                                                <i class="bx bx-image text-muted" style="font-size: 40px;"></i>
                                                <p class="mt-2 mb-0">No Image</p>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- Quick Actions -->
                        <div class="card mb-4">
                            <div class="card-body">
                                <h5 class="section-title">
                                    <i class="bx bx-cog"></i> Quick Actions
                                </h5>
                                
                                <div class="d-grid gap-2">
                                    <a href="{{ route('categories.edit', $category->id) }}" 
                                       class="btn btn-primary">
                                        <i class="bx bx-edit"></i> Edit Category
                                    </a>
                                    
                                    <button type="button" 
                                            class="btn btn-outline-danger" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#deleteModal">
                                        <i class="bx bx-trash"></i> Delete Category
                                    </button>
                                    
                                    <a href="{{ route('categories.create') }}?parent={{ $category->id }}" 
                                       class="btn btn-outline-success">
                                        <i class="bx bx-plus"></i> Add Child Category
                                    </a>
                                    
                                    <a href="{{ route('categories.index') }}" 
                                       class="btn btn-outline-secondary">
                                        <i class="bx bx-list-ul"></i> View All Categories
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Statistics -->
                        <div class="card">
                            <div class="card-body">
                                <h5 class="section-title">
                                    <i class="bx bx-stats"></i> Statistics
                                </h5>
                                
                                <div class="row text-center">
                                    <div class="col-6 mb-3">
                                        <div class="p-3 bg-light rounded">
                                            <h4 class="mb-0">{{ $category->children->count() }}</h4>
                                            <small class="text-muted">Child Categories</small>
                                        </div>
                                    </div>
                                    <div class="col-6 mb-3">
                                        <div class="p-3 bg-light rounded">
                                            <h4 class="mb-0">{{ $category->is_active ? 'Yes' : 'No' }}</h4>
                                            <small class="text-muted">Active Status</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="p-3 bg-light rounded">
                                            <h4 class="mb-0">{{ $category->sort_order }}</h4>
                                            <small class="text-muted">Sort Order</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="p-3 bg-light rounded">
                                            <h4 class="mb-0">{{ $category->created_at->format('M Y') }}</h4>
                                            <small class="text-muted">Created</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-danger">
                    <h6 class="alert-heading"><i class="bx bx-error"></i> Warning!</h6>
                    <p class="mb-0">You are about to delete the category "<strong>{{ $category->name }}</strong>".</p>
                    
                    @if($category->children->count() > 0)
                        <div class="mt-3">
                            <p class="mb-1"><i class="bx bx-error-circle"></i> This category has {{ $category->children->count() }} child categories:</p>
                            <ul class="mb-0">
                                @foreach($category->children->take(3) as $child)
                                    <li>{{ $child->name }}</li>
                                @endforeach
                                @if($category->children->count() > 3)
                                    <li>... and {{ $category->children->count() - 3 }} more</li>
                                @endif
                            </ul>
                            <p class="mt-2 mb-0"><strong>All child categories will also be deleted!</strong></p>
                        </div>
                    @endif
                    
                    <p class="mt-3 mb-0">This action cannot be undone. Are you sure you want to proceed?</p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form action="{{ route('categories.destroy', $category->id) }}" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="bx bx-trash"></i> Delete Category
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    $(document).ready(function() {
        // Category image click to view full size
        $('.category-image').click(function() {
            window.open($(this).attr('src'), '_blank');
        });
        
        // Show success message if redirected from create/update
        @if(session('success'))
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: '{{ session('success') }}',
                timer: 3000,
                showConfirmButton: false
            });
        @endif
        
        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            $('.alert').fadeOut('slow');
        }, 5000);
    });
</script>
@endsection