@extends('layouts.auth')

@section('title', 'Login - AutoPOS')

@section('content')
<div class="authentication-inner row m-0">

    <!-- Login form -->
    <div class="col-lg-6 d-flex align-items-center justify-content-center p-4">
        <div class="w-100 p-4">
            <h2 class="text-center mb-4">Login</h2>

            @if (session('status'))
                <div class="alert alert-success">{{ session('status') }}</div>
            @endif

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">@foreach ($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
                </div>
            @endif

            <form method="POST" action="{{ route('login.store') }}">
                @csrf

                <div class="mb-3">
                    <label for="email" class="form-label">Email</label>
                    <input id="email" type="email" class="form-control" name="email" value="{{ old('email') }}" required autofocus>
                </div>

                <div class="mb-3">
                    <label for="password" class="form-label">Password</label>
                    <input id="password" type="password" class="form-control" name="password" required>
                </div>

                <div class="mb-3 form-check">
                    <input type="checkbox" class="form-check-input" id="remember" name="remember">
                    <label class="form-check-label" for="remember">Remember Me</label>
                </div>

                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">Login</button>
                </div>

                @if (Route::has('password.request'))
                    <p class="mt-3 text-center"><a href="{{ route('password.request') }}">Forgot your password?</a></p>
                @endif

                <p class="mt-2 text-center">
                    Don't have an account? <a href="{{ route('register') }}">Register</a>
                </p>
            </form>
        </div>
    </div>

    <!-- Illustration panel -->
    <div class="col-lg-6 d-none d-lg-flex align-items-center justify-content-center bg-primary text-white">
        <div class="p-5 text-center">
            <h3>Welcome Back</h3>
            <p>Login to manage your sales and inventory efficiently.</p>
        </div>
    </div>

</div>
@endsection
