// public/js/pos/plugins/plugin-manager.js
class PluginManager {
    constructor() {
        this.plugins = new Map();
        this.hooks = new Map();
    }
    
    registerPlugin(name, plugin) {
        this.plugins.set(name, plugin);
        
        // Register plugin hooks
        if (plugin.hooks) {
            plugin.hooks.forEach(hook => {
                this.registerHook(hook.name, hook.handler);
            });
        }
    }
    
    registerHook(hookName, handler) {
        if (!this.hooks.has(hookName)) {
            this.hooks.set(hookName, []);
        }
        this.hooks.get(hookName).push(handler);
    }
    
    async executeHook(hookName, data) {
        const handlers = this.hooks.get(hookName) || [];
        
        for (const handler of handlers) {
            try {
                const result = await handler(data);
                if (result === false) {
                    return false; // Stop execution
                }
                if (result) {
                    data = result; // Update data
                }
            } catch (error) {
                console.error(`Hook ${hookName} error:`, error);
            }
        }
        
        return data;
    }
}

// Example plugin
class ReceiptPrintingPlugin {
    constructor() {
        this.name = 'ReceiptPrinting';
        this.hooks = [
            {
                name: 'payment:complete',
                handler: this.onPaymentComplete.bind(this)
            }
        ];
    }
    
    async onPaymentComplete(data) {
        if (data.method === 'cash') {
            await this.printReceipt(data);
        }
    }
    
    async printReceipt(data) {
        // Thermal printer integration
    }
}