// POS Statistics Module
// =========================================================

class POSStats {
// In your stats loading code
async loadToday() {
    try {
        const response = await fetch('/api/stats/today');
        const data = await response.json();
        
        if (data.success) {
            // Safely update stats, handling missing properties
            document.getElementById('todaySalesCount').textContent = 
                data.data?.total_sales || 0;
            document.getElementById('todayRevenue').textContent = 
                `KES ${(data.data?.total_revenue || 0).toFixed(2)}`;
            document.getElementById('avgSale').textContent = 
                `KES ${(data.data?.average_sale || 0).toFixed(2)}`;
            document.getElementById('todayCustomers').textContent = 
                data.data?.customer_count || 0;
        }
    } catch (error) {
        console.error('Stats load error:', error);
        // Set default values
        document.getElementById('todaySalesCount').textContent = '0';
        document.getElementById('todayRevenue').textContent = 'KES 0';
        document.getElementById('avgSale').textContent = 'KES 0';
        document.getElementById('todayCustomers').textContent = '0';
    }
}
    
    static updateTodayStats(data) {
        const elements = {
            'todaySalesCount': data.sales_count || 0,
            'todayRevenue': 'KES ' + (data.revenue || 0).toFixed(2),
            'avgSale': 'KES ' + (data.average_sale || 0).toFixed(2),
            'todayCustomers': data.customers_count || 0
        };
        
        for (const [id, value] of Object.entries(elements)) {
            const element = document.getElementById(id);
            if (element) element.textContent = value;
        }
    }
    
    static async loadDailySales(days = 7) {
        try {
            const response = await fetch(`/api/stats/daily-sales?days=${days}`);
            const data = await response.json();
            
            if (data.success) {
                return data.sales;
            }
            return [];
        } catch (error) {
            console.error('Error loading daily sales:', error);
            return [];
        }
    }
    
    static async loadTopProducts(limit = 10) {
        try {
            const response = await fetch(`/api/stats/top-products?limit=${limit}`);
            const data = await response.json();
            
            if (data.success) {
                return data.products;
            }
            return [];
        } catch (error) {
            console.error('Error loading top products:', error);
            return [];
        }
    }
    
    static async loadTopCustomers(limit = 10) {
        try {
            const response = await fetch(`/api/stats/top-customers?limit=${limit}`);
            const data = await response.json();
            
            if (data.success) {
                return data.customers;
            }
            return [];
        } catch (error) {
            console.error('Error loading top customers:', error);
            return [];
        }
    }
    
    static async loadHourlyStats(date = null) {
        try {
            let url = '/api/stats/hourly';
            if (date) {
                url += `?date=${date}`;
            }
            
            const response = await fetch(url);
            const data = await response.json();
            
            if (data.success) {
                return data.hours;
            }
            return [];
        } catch (error) {
            console.error('Error loading hourly stats:', error);
            return [];
        }
    }
    
    static async loadCategoryStats() {
        try {
            const response = await fetch('/api/stats/categories');
            const data = await response.json();
            
            if (data.success) {
                return data.categories;
            }
            return [];
        } catch (error) {
            console.error('Error loading category stats:', error);
            return [];
        }
    }
    
    static async loadPaymentMethodStats() {
        try {
            const response = await fetch('/api/stats/payment-methods');
            const data = await response.json();
            
            if (data.success) {
                return data.methods;
            }
            return [];
        } catch (error) {
            console.error('Error loading payment method stats:', error);
            return [];
        }
    }
}

// Export for global access
window.POSStats = POSStats;
window.loadTodayStats = () => POSStats.loadToday();