// public/js/pos/modules/numbers.js
class POSNumberManager {
    static async generateNumbers() {
        try {
            const response = await fetch('/api/sales/next-numbers');
            const data = await response.json();
            
            if (data.success) {
                return {
                    invoice: data.next_invoice,
                    receipt: data.next_receipt
                };
            }
            return null;
        } catch (error) {
            console.error('Error generating numbers:', error);
            return this.generateFallbackNumbers();
        }
    }
    
    static generateFallbackNumbers() {
        const date = new Date();
        const dateStr = date.toISOString().slice(0,10).replace(/-/g,'');
        const random = Math.floor(Math.random() * 1000).toString().padStart(3,'0');
        
        return {
            invoice: `INV-${dateStr}-${random}`,
            receipt: `RCPT-${dateStr}-${random}`
        };
    }
    
    static updateUINumbers(numbers) {
        // Update invoice display
        const invoiceElements = document.querySelectorAll('[data-invoice-number]');
        invoiceElements.forEach(el => {
            el.textContent = numbers.invoice;
        });
        
        // Update receipt display
        const receiptElements = document.querySelectorAll('[data-receipt-number]');
        receiptElements.forEach(el => {
            el.textContent = numbers.receipt;
        });
        
        // Update display number
        const displayElements = document.querySelectorAll('[data-display-number]');
        displayElements.forEach(el => {
            el.textContent = numbers.invoice || numbers.receipt;
        });
    }
    
    static getNumberFormat(type = 'invoice') {
        const formats = {
            invoice: {
                prefix: 'INV',
                pattern: '{prefix}-{date}-{sequence}',
                example: 'INV-20231201-001'
            },
            receipt: {
                prefix: 'RCPT',
                pattern: '{prefix}-{date}-{sequence}',
                example: 'RCPT-20231201-001'
            }
        };
        
        return formats[type] || formats.invoice;
    }
}

// Export for global access
window.POSNumberManager = POSNumberManager;