// public/js/pos/features/feature-flags.js
class FeatureFlags {
    constructor() {
        this.flags = new Map();
        this.loadFlags();
    }
    
    async loadFlags() {
        try {
            const response = await fetch('/api/v1/features/flags');
            const data = await response.json();
            this.flags = new Map(Object.entries(data.flags || {}));
        } catch (error) {
            // Default flags
            this.flags.set('mpesaEnabled', true);
            this.flags.set('etimsEnabled', false);
            this.flags.set('splitPaymentEnabled', true);
        }
    }
    
    isEnabled(feature) {
        return this.flags.get(feature) || false;
    }
    
    enable(feature) {
        this.flags.set(feature, true);
    }
    
    disable(feature) {
        this.flags.set(feature, false);
    }
}