// public/js/pos/debug.js
(function() {
    console.log('=== POS MODULE DEBUG ===');
    
    // List all expected modules
    const expectedModules = [
        'posState',
        'POSUtils',
        'POSCart',
        'POSProducts',
        'POSCustomers',
        'POSPayments',
        'POSHeldSales',
        'POSPrinter',
        'POSReceipts',
        'POSScanner',
        'POSDiscounts',
        'POSStats',
        'POSMpesa',
        'POSMpesaManager',
        'POSEvents',
        'initPOS'
    ];
    
    console.log('Checking loaded modules...');
    expectedModules.forEach(moduleName => {
        if (window[moduleName]) {
            console.log(`✅ ${moduleName}:`, typeof window[moduleName]);
        } else {
            console.error(`❌ ${moduleName}: NOT FOUND`);
        }
    });
    
    // Check if modules have required methods
    if (window.POSUtils) {
        console.log('POSUtils methods:', Object.getOwnPropertyNames(Object.getPrototypeOf(window.POSUtils)));
    }
    
    if (window.POSCart) {
        console.log('POSCart methods:', Object.getOwnPropertyNames(Object.getPrototypeOf(window.POSCart)));
    }
})();