// public/js/pos/analytics/analytics.js
class POSAnalytics {
    constructor() {
        this.events = [];
        this.sessionId = this.generateSessionId();
    }
    
    track(event, data = {}) {
        const eventData = {
            event,
            data,
            timestamp: new Date().toISOString(),
            sessionId: this.sessionId,
            userId: window.currentUser?.id,
            cartSize: posState.getCart().length,
            cartTotal: posState.getCartTotal()
        };
        
        this.events.push(eventData);
        
        // Send to server in batches
        if (this.events.length >= 10) {
            this.flush();
        }
    }
    
    async flush() {
        if (this.events.length === 0) return;
        
        try {
            await fetch('/api/v1/analytics/events', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ events: this.events })
            });
            
            this.events = [];
        } catch (error) {
            // Store in localStorage for later
            this.saveToStorage();
        }
    }
    
    generateSessionId() {
        return 'session_' + Date.now() + '_' + Math.random().toString(36).substr(2, 9);
    }
}