<?php

namespace Database\Seeders;

use App\Models\ReceiptSetting;
use Illuminate\Database\Seeder;

class ReceiptSettingsSeeder extends Seeder
{
    public function run()
    {
        $settings = [
            [
                'name' => 'Standard Thermal',
                'paper_size' => '80mm',
                'chars_per_line' => 42,
                'encoding' => 'CP850',
                'auto_cut' => true,
                'auto_open_drawer' => false,
                'print_store_name' => true,
                'print_store_address' => true,
                'print_store_phone' => true,
                'print_vat_number' => true,
                'print_branch_code' => true,
                'print_cashier_name' => true,
                'print_date_time' => true,
                'print_transaction_number' => true,
                'print_qr_code' => true,
                'qr_code_type' => 'store_info',
                'print_tax_breakdown' => true,
                'print_discounts' => true,
                'print_payment_method' => true,
                'print_change_amount' => true,
                'footer_text' => 'Thank you for shopping with us!',
                'print_footer' => true,
                'copies' => 1,
                'is_default' => true,
                'is_active' => true,
            ],
            [
                'name' => 'Invoice Style',
                'paper_size' => 'A4',
                'chars_per_line' => 80,
                'encoding' => 'UTF-8',
                'auto_cut' => false,
                'print_store_logo' => true,
                'print_store_name' => true,
                'print_store_address' => true,
                'print_store_phone' => true,
                'print_vat_number' => true,
                'print_branch_code' => true,
                'print_cashier_name' => true,
                'print_date_time' => true,
                'print_transaction_number' => true,
                'print_customer_info' => true,
                'print_tax_breakdown' => true,
                'print_discounts' => true,
                'print_payment_method' => true,
                'print_change_amount' => true,
                'footer_text' => 'This is a tax invoice',
                'print_footer' => true,
                'copies' => 1,
                'is_default' => false,
                'is_active' => true,
            ],
        ];

        foreach ($settings as $setting) {
            ReceiptSetting::create($setting);
        }
    }
}