<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class MpesaPermissionsSeeder extends Seeder
{
    public function run()
    {
        // Create M-Pesa permissions
        $permissions = [
            'mpesa.view',
            'mpesa.manage',
            'mpesa.transactions.view',
            'mpesa.transactions.manage',
            'mpesa.transactions.match',
            'mpesa.transactions.reverse',
            'mpesa.configuration.view',
            'mpesa.configuration.manage',
            'mpesa.reports.view',
            'mpesa.reports.generate',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'web']);
        }

        // Assign permissions to roles
        $adminRole = Role::where('name', 'admin')->first();
        $managerRole = Role::where('name', 'manager')->first();
        $cashierRole = Role::where('name', 'cashier')->first();

        if ($adminRole) {
            $adminRole->givePermissionTo($permissions);
        }

        if ($managerRole) {
            $managerPermissions = [
                'mpesa.view',
                'mpesa.transactions.view',
                'mpesa.transactions.match',
                'mpesa.transactions.reverse',
                'mpesa.configuration.view',
                'mpesa.reports.view',
                'mpesa.reports.generate',
            ];
            $managerRole->givePermissionTo($managerPermissions);
        }

        if ($cashierRole) {
            $cashierPermissions = [
                'mpesa.view',
                'mpesa.transactions.view',
            ];
            $cashierRole->givePermissionTo($cashierPermissions);
        }

        $this->command->info('M-Pesa permissions created and assigned successfully.');
    }
}