<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ETIMSCredential;
use Illuminate\Support\Facades\Crypt;

class ETIMSCredentialSeeder extends Seeder
{
    public function run(): void
    {
        // Check if table exists
        if (!\Schema::hasTable('etims_credentials')) {
            $this->command->info('ETIMS credentials table does not exist.');
            return;
        }

        // Check if already seeded
        if (ETIMSCredential::count() > 0) {
            $this->command->info('ETIMS credentials already seeded.');
            return;
        }

        // Create sandbox credentials for testing
        ETIMSCredential::create([
            'name' => 'Sandbox eTIMS',
            'tin' => Crypt::encryptString('P051000000000'), // Sample TIN
            'consumer_key' => Crypt::encryptString('sandbox_consumer_key'),
            'consumer_secret' => Crypt::encryptString('sandbox_consumer_secret'),
            'api_url' => 'https://etims.sandbox.kra.go.ke',
            'environment' => 'sandbox',
            'branch_id' => '01',
            'branch_name' => 'Main Branch',
            'is_active' => false, // Set to true when you have real credentials
            'notes' => 'Sandbox credentials for testing. Replace with real credentials for production.',
        ]);

        $this->command->info('ETIMS credentials seeded successfully.');
        $this->command->info('⚠️  Remember to update with your real KRA eTIMS credentials for production.');
    }
}