<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class AdminUserSeeder extends Seeder
{
    public function run()
    {
        // Check if admin user already exists
        $adminExists = User::where('email', 'admin@example.com')->exists();
        
        if (!$adminExists) {
            // Create admin user
            $admin = User::create([
                'name' => 'Administrator',
                'email' => 'admin@example.com',
                'password' => Hash::make('password123'), // Change this password!
                'email_verified_at' => now(),
            ]);
            
            // Assign admin role
            $adminRole = Role::where('name', 'admin')->first();
            if ($adminRole) {
                $admin->assignRole($adminRole);
            }
            
            $this->command->info('Admin user created successfully!');
            $this->command->info('Email: admin@example.com');
            $this->command->info('Password: password123');
        } else {
            $this->command->info('Admin user already exists.');
        }
        
        // You can create other demo users if needed
        $this->createDemoUsers();
    }
    
    private function createDemoUsers()
    {
        $users = [
            [
                'name' => 'Manager User',
                'email' => 'manager@example.com',
                'password' => Hash::make('password123'),
                'role' => 'manager'
            ],
            [
                'name' => 'Cashier User',
                'email' => 'cashier@example.com',
                'password' => Hash::make('password123'),
                'role' => 'cashier'
            ],
            [
                'name' => 'Purchaser User',
                'email' => 'purchaser@example.com',
                'password' => Hash::make('password123'),
                'role' => 'purchaser'
            ],
        ];
        
        foreach ($users as $userData) {
            $userExists = User::where('email', $userData['email'])->exists();
            
            if (!$userExists) {
                $user = User::create([
                    'name' => $userData['name'],
                    'email' => $userData['email'],
                    'password' => $userData['password'],
                    'email_verified_at' => now(),
                ]);
                
                $role = Role::where('name', $userData['role'])->first();
                if ($role) {
                    $user->assignRole($role);
                }
            }
        }
        
        $this->command->info('Demo users created successfully!');
    }
}