<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        /**
         * Ensure callback_url exists and is NOT NULL
         */
        if (!Schema::hasColumn('mpesa_credentials', 'callback_url')) {
            DB::statement("
                ALTER TABLE mpesa_credentials
                ADD callback_url VARCHAR(255) NOT NULL
            ");
        } else {
            DB::statement("
                ALTER TABLE mpesa_credentials
                MODIFY callback_url VARCHAR(255) NOT NULL
            ");
        }

        /**
         * Ensure is_active default = 1 (true)
         */
        DB::statement("
            ALTER TABLE mpesa_credentials
            MODIFY is_active TINYINT(1) NOT NULL DEFAULT 1
        ");
    }

    public function down(): void
    {
        /**
         * Revert changes safely
         */
        DB::statement("
            ALTER TABLE mpesa_credentials
            MODIFY callback_url VARCHAR(255) NULL
        ");

        DB::statement("
            ALTER TABLE mpesa_credentials
            MODIFY is_active TINYINT(1) NOT NULL DEFAULT 0
        ");
    }
};
