<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('activity_log', function (Blueprint $table) {
            if (!Schema::hasColumn('activity_log', 'ip_address')) {
                $table->string('ip_address')->nullable()->after('batch_uuid');
            }
            
            if (!Schema::hasColumn('activity_log', 'user_agent')) {
                $table->text('user_agent')->nullable()->after('ip_address');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('activity_log', function (Blueprint $table) {
            if (Schema::hasColumn('activity_log', 'ip_address')) {
                $table->dropColumn('ip_address');
            }
            
            if (Schema::hasColumn('activity_log', 'user_agent')) {
                $table->dropColumn('user_agent');
            }
        });
    }
};