<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMissingColumnsToSalesTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            // Add vat_amount column (sum of tax_amount from sale_items for VAT calculation)
            if (!Schema::hasColumn('sales', 'vat_amount')) {
                $table->decimal('vat_amount', 10, 2)->default(0)->after('tax_total');
            }
            
            // Add discount_amount column
            if (!Schema::hasColumn('sales', 'discount_amount')) {
                $table->decimal('discount_amount', 10, 2)->default(0)->after('discount');
            }
            
            // Note: 'change' column already exists as 'customer_change' in your table
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->dropColumn(['vat_amount', 'discount_amount']);
        });
    }
}