<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('phone')->nullable()->after('email');
            $table->string('profile_image')->nullable()->after('phone');
            $table->boolean('status')->default(true)->after('profile_image');
            $table->timestamp('last_login_at')->nullable()->after('status');
            $table->string('last_login_ip')->nullable()->after('last_login_at');
            $table->json('settings')->nullable()->after('last_login_ip');
            $table->string('department')->nullable()->after('settings');
            $table->string('position')->nullable()->after('department');
            $table->text('address')->nullable()->after('position');
            $table->date('date_of_birth')->nullable()->after('address');
            $table->enum('gender', ['male', 'female', 'other'])->nullable()->after('date_of_birth');
            $table->string('employee_id')->nullable()->unique()->after('gender');
            $table->date('hire_date')->nullable()->after('employee_id');
            $table->text('notes')->nullable()->after('hire_date');
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'phone',
                'profile_image',
                'status',
                'last_login_at',
                'last_login_ip',
                'settings',
                'department',
                'position',
                'address',
                'date_of_birth',
                'gender',
                'employee_id',
                'hire_date',
                'notes',
            ]);
            $table->dropSoftDeletes();
        });
    }
};