<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('unified_number_sequences', function (Blueprint $table) {
            $table->id();
            $table->date('date');
            $table->string('type')->default('invoice_receipt');
            $table->integer('last_number')->default(0);
            $table->string('prefix')->default('INVRCP');
            $table->string('format')->nullable();
            $table->timestamps();
            
            $table->unique(['date', 'type']);
            $table->index(['date', 'type']);
        });
        
        // Add unified_number column to sales table
        Schema::table('sales', function (Blueprint $table) {
            $table->string('unified_number')->nullable()->after('receipt_no');
            $table->index('unified_number');
        });
    }
    
    public function down(): void
    {
        Schema::dropIfExists('unified_number_sequences');
        
        Schema::table('sales', function (Blueprint $table) {
            $table->dropColumn('unified_number');
        });
    }
};