<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Storage;
use App\Models\StoreInformation;

return new class extends Migration
{
    public function up()
    {
        // Ensure the logos directory exists
        if (!Storage::exists('public/store/logos')) {
            Storage::makeDirectory('public/store/logos', 0755, true);
        }
        
        // Fix existing logo paths if needed
        $store = StoreInformation::first();
        if ($store && $store->logo) {
            // If logo is stored without path, add it
            if (!filter_var($store->logo, FILTER_VALIDATE_URL)) {
                $logoPath = $store->logo;
                
                // Check if it's just a filename
                if (!str_contains($logoPath, '/')) {
                    // Check if file exists in old location
                    $oldLocation = 'public/' . $logoPath;
                    $newLocation = 'public/store/logos/' . $logoPath;
                    
                    if (Storage::exists($oldLocation)) {
                        // Move the file
                        Storage::move($oldLocation, $newLocation);
                        $store->logo = 'store/logos/' . $logoPath;
                        $store->save();
                    }
                }
            }
        }
    }

    public function down()
    {
        // Optional: Revert if needed
    }
};