<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check and add discount_percent column
        if (!DB::select("SHOW COLUMNS FROM customers LIKE 'discount_percent'")) {
            DB::statement("ALTER TABLE customers ADD COLUMN discount_percent DECIMAL(5,2) DEFAULT 0.00 AFTER loyalty_points");
        }
        
        // Check and add created_by column
        if (!DB::select("SHOW COLUMNS FROM customers LIKE 'created_by'")) {
            DB::statement("ALTER TABLE customers ADD COLUMN created_by BIGINT UNSIGNED NULL AFTER zero_rated_reason");
        }
        
        // Check and add updated_by column
        if (!DB::select("SHOW COLUMNS FROM customers LIKE 'updated_by'")) {
            DB::statement("ALTER TABLE customers ADD COLUMN updated_by BIGINT UNSIGNED NULL AFTER created_by");
        }
        
        // Add indexes for better performance
        DB::statement("ALTER TABLE customers ADD INDEX customers_vat_status_idx (vat_number, status)");
        DB::statement("ALTER TABLE customers ADD INDEX customers_type_status_idx (customer_type, status)");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement("ALTER TABLE customers DROP COLUMN IF EXISTS discount_percent");
        DB::statement("ALTER TABLE customers DROP COLUMN IF EXISTS created_by");
        DB::statement("ALTER TABLE customers DROP COLUMN IF EXISTS updated_by");
        DB::statement("ALTER TABLE customers DROP INDEX IF EXISTS customers_vat_status_idx");
        DB::statement("ALTER TABLE customers DROP INDEX IF EXISTS customers_type_status_idx");
    }
};