<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->string('invoice_no')->nullable()->unique()->after('receipt_no');
            $table->text('notes')->nullable()->after('payment_status');
            $table->dateTime('sale_date')->nullable()->after('notes');
        });
    }

    public function down(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->dropUnique(['invoice_no']);
            $table->dropColumn(['invoice_no', 'notes', 'sale_date']);
        });
    }
};
