<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class AddSplitPaymentMethod extends Migration
{
    public function up()
    {
        // Check if it already exists
        $exists = DB::table('payment_methods')->where('code', 'multiple')->exists();
        
        if (!$exists) {
            DB::table('payment_methods')->insert([
                [
                    'name' => 'Split Payment',
                    'code' => 'multiple',
                    'type' => 'split',
                    'provider' => 'split',
                    'is_active' => 1,
                    'requires_confirmation' => 0,
                    'config' => json_encode(['max_methods' => 3]),
                    'sort_order' => 7,
                    'icon' => 'layer',
                    'description' => 'Multiple payment methods',
                    'created_at' => now(),
                    'updated_at' => now(),
                ]
            ]);
        }
    }

    public function down()
    {
        DB::table('payment_methods')->where('code', 'multiple')->delete();
    }
}