<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddExtraFieldsToPaymentMethodsTable extends Migration
{
    public function up()
    {
        Schema::table('payment_methods', function (Blueprint $table) {
            $table->string('code')->nullable()->after('name');
            $table->string('type')->nullable()->after('code'); // cash, mobile, card, etc
            $table->string('provider')->nullable()->after('type'); // mpesa, pesapal, etc
            $table->boolean('requires_confirmation')->default(false)->after('is_active');
            $table->json('config')->nullable()->after('requires_confirmation');
            $table->integer('sort_order')->default(0)->after('config');
            $table->string('icon')->nullable()->after('sort_order');
            $table->text('description')->nullable()->after('icon');
        });
    }

    public function down()
    {
        Schema::table('payment_methods', function (Blueprint $table) {
            $table->dropColumn([
                'code',
                'type',
                'provider',
                'requires_confirmation',
                'config',
                'sort_order',
                'icon',
                'description',
            ]);
        });
    }
}
