<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHoldSalesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
        public function up()
        {
            Schema::create('hold_sales', function (Blueprint $table) {
                $table->id();
                $table->string('reference')->unique();
                $table->foreignId('customer_id')->nullable()->constrained()->nullOnDelete();
                $table->foreignId('user_id')->constrained()->cascadeOnDelete();
                $table->json('items');
                $table->decimal('total', 15, 2);
                $table->decimal('subtotal', 15, 2);
                $table->decimal('vat', 15, 2)->default(0);
                $table->decimal('discount', 15, 2)->default(0);
                $table->text('notes')->nullable();
                $table->string('status')->default('active'); // active, expired, converted
                $table->timestamp('expires_at');
                $table->timestamp('converted_at')->nullable();
                $table->timestamps();
                
                $table->index(['status', 'expires_at']);
                $table->index('reference');
                $table->index('user_id');
            });
        }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hold_sales');
    }
}
