<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('etims_credentials', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('tin'); // Encrypted
            $table->text('consumer_key'); // Encrypted
            $table->text('consumer_secret'); // Encrypted
            $table->string('api_url');
            $table->enum('environment', ['sandbox', 'production'])->default('sandbox');
            $table->string('branch_id')->nullable();
            $table->string('branch_name')->nullable();
            $table->boolean('is_active')->default(false);
            $table->timestamp('last_sync')->nullable();
            $table->enum('sync_status', ['pending', 'success', 'failed'])->default('pending');
            $table->text('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            // Indexes
            $table->index('is_active');
            $table->index('environment');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('etims_credentials');
    }
};