<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // Update status column to accept all workflow statuses
        DB::statement("ALTER TABLE purchases MODIFY COLUMN status ENUM('draft', 'pending', 'approved', 'received', 'completed', 'delivered', 'cancelled') NOT NULL DEFAULT 'pending'");
        
        // Add workflow columns
        Schema::table('purchases', function (Blueprint $table) {
            if (!Schema::hasColumn('purchases', 'approved_at')) {
                $table->timestamp('approved_at')->nullable()->after('updated_by');
            }
            if (!Schema::hasColumn('purchases', 'approved_by')) {
                $table->foreignId('approved_by')->nullable()->constrained('users')->after('approved_at');
            }
            if (!Schema::hasColumn('purchases', 'received_at')) {
                $table->timestamp('received_at')->nullable()->after('approved_by');
            }
            if (!Schema::hasColumn('purchases', 'received_by')) {
                $table->foreignId('received_by')->nullable()->constrained('users')->after('received_at');
            }
            if (!Schema::hasColumn('purchases', 'delivered_at')) {
                $table->timestamp('delivered_at')->nullable()->after('received_by');
            }
        });
    }

    public function down(): void
    {
        DB::statement("ALTER TABLE purchases MODIFY COLUMN status ENUM('draft', 'pending', 'completed', 'cancelled') NOT NULL DEFAULT 'pending'");
        
        Schema::table('purchases', function (Blueprint $table) {
            $table->dropColumn(['approved_at', 'approved_by', 'received_at', 'received_by', 'delivered_at']);
        });
    }
};