<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddWorkflowFieldsToPurchasesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
// In the migration file:
public function up()
{
    Schema::table('purchases', function (Blueprint $table) {
        $table->timestamp('approved_at')->nullable();
        $table->foreignId('approved_by')->nullable()->constrained('users');
        $table->timestamp('received_at')->nullable();
        $table->foreignId('received_by')->nullable()->constrained('users');
        $table->timestamp('delivered_at')->nullable();
    });
}

public function down()
{
    Schema::table('purchases', function (Blueprint $table) {
        $table->dropForeign(['approved_by']);
        $table->dropForeign(['received_by']);
        $table->dropColumn(['approved_at', 'approved_by', 'received_at', 'received_by', 'delivered_at']);
    });
}
}
