<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('taxes', function (Blueprint $table) {
            $table->string('code')->unique()->after('name'); // e.g., "VAT-16"
            $table->boolean('is_default')->default(false)->after('rate'); // default tax flag
            $table->text('description')->nullable()->after('is_active');
            $table->json('applicable_categories')->nullable()->after('description'); // categories this tax applies to
        });
    }

    public function down(): void {
        Schema::table('taxes', function (Blueprint $table) {
            if (Schema::hasColumn('taxes', 'code')) {
                $table->dropColumn('code');
            }
            if (Schema::hasColumn('taxes', 'is_default')) {
                $table->dropColumn('is_default');
            }
            if (Schema::hasColumn('taxes', 'description')) {
                $table->dropColumn('description');
            }
            if (Schema::hasColumn('taxes', 'applicable_categories')) {
                $table->dropColumn('applicable_categories');
            }
        });
    }
};
