<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('purchases', function (Blueprint $table) {
            // Add the missing column
            $table->boolean('is_credit_purchase')->default(false)->after('created_by');
            
            // Also check for other missing columns mentioned in the model
            if (!Schema::hasColumn('purchases', 'discount_amount')) {
                $table->decimal('discount_amount', 10, 2)->default(0)->after('subtotal');
            }
            
            if (!Schema::hasColumn('purchases', 'shipping_charges')) {
                $table->decimal('shipping_charges', 10, 2)->default(0)->after('tax_amount');
            }
            
            if (!Schema::hasColumn('purchases', 'payment_notes')) {
                $table->text('payment_notes')->nullable()->after('payment_method');
            }
            
            if (!Schema::hasColumn('purchases', 'due_date')) {
                $table->date('due_date')->nullable()->after('is_credit_purchase');
            }
        });
    }

    public function down()
    {
        Schema::table('purchases', function (Blueprint $table) {
            $table->dropColumn([
                'is_credit_purchase',
                'discount_amount',
                'shipping_charges',
                'payment_notes',
                'due_date'
            ]);
        });
    }
};