<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->foreignId('parent_id')->nullable()->after('description')->constrained('categories')->nullOnDelete();
            $table->boolean('is_active')->default(true)->after('parent_id');
            $table->string('color')->nullable()->after('is_active');
            $table->string('image')->nullable()->after('color');
            $table->integer('sort_order')->default(0)->after('image');
        });
    }

    public function down(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->dropForeign(['parent_id']);
            $table->dropColumn([
                'parent_id',
                'is_active',
                'color',
                'image',
                'sort_order'
            ]);
        });
    }
};