<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('suppliers', function (Blueprint $table) {
            $table->string('contact_person')->nullable()->after('address');
            $table->string('website')->nullable()->after('contact_person');
            $table->string('tax_id')->nullable()->after('website');
            $table->string('payment_terms')->nullable()->after('tax_id');
            $table->text('notes')->nullable()->after('payment_terms');
            $table->enum('status', ['active', 'inactive'])->default('active')->after('notes');
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::table('suppliers', function (Blueprint $table) {
            $table->dropColumn([
                'contact_person',
                'website',
                'tax_id',
                'payment_terms',
                'notes',
                'status',
                'deleted_at'
            ]);
        });
    }
};