<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('sale_items', function (Blueprint $table) {
            // rate stored as percentage (e.g. 16.00)
            if (! Schema::hasColumn('sale_items', 'tax_rate')) {
                $table->decimal('tax_rate', 5, 2)->nullable()->after('price');
            }
            if (! Schema::hasColumn('sale_items', 'tax_amount')) {
                $table->decimal('tax_amount', 12, 2)->default(0)->after('tax_rate');
            }
            if (! Schema::hasColumn('sale_items', 'price_ex_tax')) {
                $table->decimal('price_ex_tax', 12, 2)->nullable()->after('price');
            }
        });

        Schema::table('sales', function (Blueprint $table) {
            if (! Schema::hasColumn('sales', 'tax_total')) {
                $table->decimal('tax_total', 12, 2)->default(0)->after('subtotal');
            }
        });
    }

    public function down(): void {
        Schema::table('sale_items', function (Blueprint $table) {
            if (Schema::hasColumn('sale_items','tax_rate')) $table->dropColumn('tax_rate');
            if (Schema::hasColumn('sale_items','tax_amount')) $table->dropColumn('tax_amount');
            if (Schema::hasColumn('sale_items','price_ex_tax')) $table->dropColumn('price_ex_tax');
        });
        Schema::table('sales', function (Blueprint $table) {
            if (Schema::hasColumn('sales','tax_total')) $table->dropColumn('tax_total');
        });
    }
};
