<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->longText('value')->nullable();
            $table->timestamps();
        });

        // Default system settings
        DB::table('settings')->insert([
            ['key' => 'currency', 'value' => 'KES'],
            ['key' => 'currency_symbol', 'value' => 'KSh'],
            ['key' => 'shop_name', 'value' => 'My Shop'],
            ['key' => 'shop_location', 'value' => 'Nairobi, Kenya'],
            ['key' => 'receipt_footer', 'value' => "Thank you for shopping with us!"],
            ['key' => 'backup_enabled', 'value' => '1'],   // 1 = Enabled, 0 = Disabled
            ['key' => 'backup_frequency', 'value' => 'daily'], // daily | weekly | monthly
            ['key' => 'backup_disk', 'value' => 'local'], // local | s3 | dropbox | google
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
