<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sale_id')->constrained()->cascadeOnDelete();
            $table->foreignId('payment_method_id')->constrained()->restrictOnDelete();

            $table->decimal('amount', 15, 2);
            $table->string('reference')->nullable(); 
            // For bank: transaction id
            // COD: customer name or delivery reference
            // Mpesa: MPESA code (later)

            $table->json('meta')->nullable(); // flexible field for future expansion

            $table->dateTime('paid_at');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
