<?php

namespace Database\Factories;

use App\Models\Brand;
use Illuminate\Database\Eloquent\Factories\Factory;

class BrandFactory extends Factory
{
    protected $model = Brand::class;

    public function definition()
    {
        $countries = ['United States', 'China', 'Japan', 'Germany', 'United Kingdom', 'France', 'Italy', 'South Korea'];
        
        return [
            'name' => $this->faker->company(),
            'slug' => $this->faker->slug(),
            'description' => $this->faker->paragraph(),
            'website' => $this->faker->url(),
            'contact_email' => $this->faker->companyEmail(),
            'contact_phone' => $this->faker->phoneNumber(),
            'status' => $this->faker->randomElement(['active', 'inactive']),
            'country' => $this->faker->randomElement($countries),
            'established_year' => $this->faker->year(),
            'is_featured' => $this->faker->boolean(20),
            'order' => $this->faker->numberBetween(0, 100),
            'meta_title' => $this->faker->sentence(),
            'meta_description' => $this->faker->paragraph(),
            'meta_keywords' => implode(', ', $this->faker->words(5)),
        ];
    }
}