<?php
// cpanel_deploy.php - Run this on cPanel after uploading files
echo "=== POS System cPanel Deployment Script ===\n\n";

// Step 1: Check PHP version
echo "1. Checking PHP version...\n";
$phpVersion = phpversion();
echo "   PHP Version: $phpVersion\n";
echo "   Required: 7.4 or higher\n\n";

// Step 2: Set permissions
echo "2. Setting file permissions...\n";
$commands = [
    'find . -type f -exec chmod 644 {} \;',
    'find . -type d -exec chmod 755 {} \;',
    'chmod -R 775 storage bootstrap/cache',
    'chmod 755 artisan'
];

foreach ($commands as $command) {
    echo "   Running: $command\n";
    system($command);
}

// Step 3: Create production .env template
echo "\n3. Creating .env production template...\n";
$envTemplate = <<<ENV
APP_NAME="AutoPOS - Kenyan Supermarket"
APP_ENV=production
APP_DEBUG=false
APP_KEY=base64:Krjp6esjd87hgpiS2C4YYrKPfGUBUDbxA06Kju8qv0I=
APP_URL=https://yourdomain.com

LOG_CHANNEL=stack
LOG_LEVEL=error

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=YOUR_CPANEL_DB_NAME
DB_USERNAME=YOUR_CPANEL_DB_USER
DB_PASSWORD=YOUR_DB_PASSWORD

BROADCAST_DRIVER=log
CACHE_DRIVER=file
QUEUE_CONNECTION=sync
SESSION_DRIVER=database
SESSION_LIFETIME=120

REDIS_HOST=127.0.0.1
REDIS_PASSWORD=null
REDIS_PORT=6379

MAIL_MAILER=smtp
MAIL_HOST=mail.yourdomain.com
MAIL_PORT=587
MAIL_USERNAME=pos@yourdomain.com
MAIL_PASSWORD=YOUR_EMAIL_PASSWORD
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=pos@yourdomain.com
MAIL_FROM_NAME="AutoPOS"

# Store Information
STORE_NAME="Your Store Name"
STORE_ADDRESS="Nairobi CBD, Kenya"
STORE_PHONE="0700 000 000"
STORE_EMAIL="info@yourstore.com"
STORE_KRA_PIN="P000000000A"
STORE_VAT_NUMBER="VAT-000-000-000"

# VAT Settings
DEFAULT_VAT_RATE=16.00
VAT_INCLUSIVE=true

# Currency Settings
CURRENCY=KES
CURRENCY_SYMBOL=KSh
CURRENCY_POSITION=left
CURRENCY_DECIMALS=2

# Security
SESSION_SECURE_COOKIE=true
SESSION_HTTP_ONLY=true
ENV;

file_put_contents('.env.production', $envTemplate);
echo "   Created .env.production template\n";

// Step 4: Show next steps
echo "\n=== DEPLOYMENT INSTRUCTIONS ===\n";
echo "1. Upload all files to cPanel public_html folder\n";
echo "2. Create database in cPanel MySQL Databases\n";
echo "3. Update .env.production with your credentials\n";
echo "4. Rename .env.production to .env\n";
echo "5. Run: composer install --no-dev --optimize-autoloader\n";
echo "6. Run: php artisan migrate --force\n";
echo "7. Run: php artisan storage:link\n";
echo "8. Visit https://yourdomain.com\n\n";

echo "=== CRON JOBS TO ADD IN CPANEL ===\n";
echo "* * * * * cd /home/YOUR_USER/public_html && php artisan schedule:run\n";
echo "0 2 * * * cd /home/YOUR_USER/public_html && php artisan backup:run\n";
echo "*/5 * * * * cd /home/YOUR_USER/public_html && php artisan mpesa:sync\n\n";

echo "Deployment script completed!\n";