<?php

return [
    // ============================================
    // STORE INFORMATION (Database with fallbacks)
    // ============================================
    'store' => [
        'name' => env('STORE_NAME', 'EFLIX digital Solutions'),
        'address' => env('STORE_ADDRESS', 'Nairobi CBD'),
        'phone' => env('STORE_PHONE', '0700 000 000'),
        'whatsapp' => env('STORE_WHATSAPP', ''),
        'email' => env('STORE_EMAIL', ''),
        'city' => env('STORE_CITY', 'Nairobi'),
        'country' => env('STORE_COUNTRY', 'Kenya'),
        'currency' => env('STORE_CURRENCY', 'KES'),
        'timezone' => env('STORE_TIMEZONE', 'Africa/Nairobi'),
        'logo' => env('STORE_LOGO', ''),
        'company_pin' => env('STORE_PIN', ''),
        'vat_number' => env('STORE_VAT_NUMBER', ''),
        'branch_code' => env('STORE_BRANCH_CODE', '001'),
        'business_registration' => env('BUSINESS_REGISTRATION', ''),
        'kra_pin' => env('KRA_PIN', ''),
        'permit_number' => env('PERMIT_NUMBER', ''),
        'business_hours' => [
            'open' => env('STORE_OPEN', '08:00'),
            'close' => env('STORE_CLOSE', '20:00'),
        ],
    ],
    
    // ============================================
    // INVOICE/RECEIPT SETTINGS
    // ============================================
    'invoice' => [
        'prefix' => env('INVOICE_PREFIX', 'INVX'),
        'receipt_prefix' => env('RECEIPT_PREFIX', 'RCP'),
        'transaction_prefix' => env('TRANSACTION_PREFIX', 'TXN'),
        
        // Numbering
        'reset_daily' => env('RESET_COUNTERS_DAILY', true),
        'number_length' => env('INVOICE_NUMBER_LENGTH', 3),
        
        // Content
        'footer' => env('RECEIPT_FOOTER', 'Thank you for your business!'),
        'header' => env('RECEIPT_HEADER', ''),
        'legal_notice' => env('RECEIPT_LEGAL', 'This receipt is computer generated and requires no signature.'),
        
        // Behavior
        'print_automatically' => env('PRINT_AUTOMATIC', true),
        'require_customer' => env('REQUIRE_CUSTOMER', false),
        'auto_generate_numbers' => env('AUTO_GENERATE_NUMBERS', true),
        
        // Notes/Disclaimers
        'notes' => [
            'Keep this receipt for warranty claims',
            'Items sold are not returnable unless defective',
            'Goods once sold cannot be returned or exchanged',
            'Please check goods before leaving the counter',
            'Valid for 7 days from date of purchase for exchanges only',
        ],
    ],
    
    // ============================================
    // VAT/TAX SETTINGS
    // ============================================
    'vat' => [
        'rate' => env('DEFAULT_VAT_RATE', 16.00),
        'inclusive' => env('VAT_INCLUSIVE', true),
        'show_breakdown' => env('SHOW_VAT_BREAKDOWN', true),
        'customer_vat_status_enabled' => env('CUSTOMER_VAT_STATUS', true),
        
        // VAT Rates configuration (can have multiple rates)
        'rates' => [
            'standard' => env('VAT_RATE_STANDARD', 16),
            'zero_rated' => env('VAT_RATE_ZERO', 0),
            'exempt' => env('VAT_RATE_EXEMPT', 0),
        ],
        
        // VAT Calculation method
        'calculation_method' => env('VAT_CALCULATION_METHOD', 'inclusive'), // 'inclusive' or 'exclusive'
    ],
    
    // ============================================
    // CURRENCY SETTINGS
    // ============================================
    'currency' => [
        'code' => env('CURRENCY', 'KES'),
        'symbol' => env('CURRENCY_SYMBOL', 'KSh'),
        'position' => env('CURRENCY_POSITION', 'left'),
        'decimals' => env('CURRENCY_DECIMALS', 2),
        'thousands_separator' => env('THOUSANDS_SEPARATOR', ','),
        'decimal_separator' => env('DECIMAL_SEPARATOR', '.'),
        
        // Formatting templates
        'format' => [
            'with_symbol' => '{symbol}{amount}',
            'without_symbol' => '{amount} {code}',
        ],
    ],
    
    // ============================================
    // STOCK SETTINGS
    // ============================================
    'stock' => [
        'low_stock_threshold' => env('LOW_STOCK_THRESHOLD', 5),
        'critical_stock_threshold' => env('CRITICAL_STOCK_THRESHOLD', 2),
        'enable_stock_alert' => env('ENABLE_STOCK_ALERT', true),
        'allow_negative_stock' => env('ALLOW_NEGATIVE_STOCK', false),
        'auto_update_stock' => env('AUTO_UPDATE_STOCK', true),
    ],
    
    // ============================================
    // PAYMENT SETTINGS
    // ============================================
    'payment' => [
        'methods' => [
            'cash' => [
                'enabled' => true,
                'require_exact_change' => env('REQUIRE_EXACT_CHANGE', false),
                'quick_amounts' => [100, 200, 500, 1000, 2000, 5000],
            ],
            'mpesa' => [
                'enabled' => env('MPESA_ENABLED', false),
                'credentials_source' => 'database', // 'database' or 'env'
                'stk_push_enabled' => env('MPESA_STK_PUSH', true),
                'manual_entry_enabled' => env('MPESA_MANUAL_ENTRY', true),
            ],
            'card' => [
                'enabled' => env('CARD_ENABLED', false),
                'types' => ['visa', 'mastercard', 'amex'],
            ],
            'credit' => [
                'enabled' => env('CREDIT_ENABLED', true),
                'default_terms' => env('CREDIT_DEFAULT_TERMS', 30),
                'require_approval' => env('CREDIT_REQUIRE_APPROVAL', false),
            ],
            'bank' => [
                'enabled' => env('BANK_ENABLED', false),
                'require_reference' => env('BANK_REQUIRE_REFERENCE', true),
            ],
        ],
        
        // General payment settings
        'default_method' => env('DEFAULT_PAYMENT_METHOD', 'cash'),
        'split_payment_enabled' => env('SPLIT_PAYMENT_ENABLED', true),
        'require_payment_confirmation' => env('REQUIRE_PAYMENT_CONFIRMATION', true),
        'auto_complete_payment' => env('AUTO_COMPLETE_PAYMENT', false),
    ],
    
    // ============================================
    // PRINTER SETTINGS
    // ============================================
    'printer' => [
        'default' => env('PRINTER_DEFAULT', 'network'),
        'auto_check_connection' => env('PRINTER_AUTO_CHECK', true),
        
        'network' => [
            'ip' => env('PRINTER_IP', env('THERMAL_PRINTER_IP', '192.168.1.100')),
            'port' => env('PRINTER_PORT', env('THERMAL_PRINTER_PORT', 9100)),
            'timeout' => env('PRINTER_TIMEOUT', 5),
        ],
        
        'usb' => [
            'device' => env('PRINTER_DEVICE', '/dev/usb/lp0'),
            'baudrate' => env('PRINTER_BAUDRATE', 9600),
        ],
        
        'file' => [
            'path' => env('PRINTER_FILE_PATH', storage_path('receipts')),
        ],
        
        // Receipt printer settings
        'receipt' => [
            'width' => env('RECEIPT_WIDTH', 80),
            'charset' => env('RECEIPT_CHARSET', 'UTF-8'),
            'cut_after_print' => env('CUT_AFTER_PRINT', true),
            'open_cash_drawer' => env('OPEN_CASH_DRAWER', false),
        ],
    ],
    
    // ============================================
    // BARCODE & SCANNER SETTINGS
    // ============================================
    'barcode' => [
        'scanner_enabled' => env('BARCODE_SCANNER_ENABLED', true),
        'camera_facing' => env('BARCODE_CAMERA_FACING', 'environment'),
        'auto_focus' => env('BARCODE_AUTO_FOCUS', true),
        'beep_on_scan' => env('BARCODE_BEEP_ON_SCAN', true),
        
        // Barcode formats
        'formats' => [
            'CODE_128',
            'CODE_39',
            'EAN_13',
            'EAN_8',
            'UPC_A',
            'UPC_E',
            'QR_CODE'
        ],
        
        // Barcode generation
        'generate_for_products' => env('GENERATE_BARCODES', true),
        'prefix' => env('BARCODE_PREFIX', 'PRD'),
    ],
    
    // ============================================
    // E-TIMS INTEGRATION SETTINGS
    // ============================================
    'etims' => [
        'enabled' => env('ETIMS_ENABLED', false),
        'environment' => env('ETIMS_ENVIRONMENT', 'sandbox'),
        
        // Credentials source
        'credentials_source' => 'database', // 'database' or 'env'
        'model' => \App\Models\ETIMSCredential::class,
        
        // API Settings
        'api' => [
            'sandbox_url' => env('ETIMS_SANDBOX_URL', 'https://etims.sandbox.kra.go.ke'),
            'production_url' => env('ETIMS_PRODUCTION_URL', 'https://etims.kra.go.ke'),
            'timeout' => env('ETIMS_TIMEOUT', 30),
            'max_retries' => env('ETIMS_MAX_RETRIES', 3),
            'retry_delay' => env('ETIMS_RETRY_DELAY', 5000),
        ],
        
        // Submission Settings
        'auto_submit' => env('ETIMS_AUTO_SUBMIT', true),
        'include_qr_code' => env('ETIMS_INCLUDE_QR', true),
        'verification_required' => env('ETIMS_VERIFICATION_REQUIRED', false),
        
        // Data Settings
        'device_id' => env('ETIMS_DEVICE_ID', ''),
        'branch_mapping' => [
            '001' => 'Main Branch',
            '002' => 'Nairobi CBD',
            '003' => 'Mombasa Branch',
        ],
    ],
    
    // ============================================
    // MPESA INTEGRATION SETTINGS
    // ============================================

        'mpesa' => [
            'enabled' => env('MPESA_ENABLED', false),
            'environment' => env('MPESA_ENVIRONMENT', 'sandbox'),
            
            // Credentials source
            'credentials_source' => 'database', // 'database' or 'env'
            'model' => \App\Models\MpesaCredential::class,
            
            // API Settings
            'api' => [
                'sandbox_url' => env('MPESA_SANDBOX_URL', 'https://sandbox.safaricom.co.ke'),
                'production_url' => env('MPESA_PRODUCTION_URL', 'https://api.safaricom.co.ke'),
                'callback_url' => env('MPESA_CALLBACK_URL', env('APP_URL') . '/api/mpesa/callback'),
                'validation_url' => env('MPESA_VALIDATION_URL', env('APP_URL') . '/api/mpesa/validation'),
                'confirmation_url' => env('MPESA_CONFIRMATION_URL', env('APP_URL') . '/api/mpesa/confirmation'),
                'timeout' => env('MPESA_TIMEOUT', 30),
            ],
            
            // STK Push Settings
            'stk_push' => [
                'enabled' => env('MPESA_STK_PUSH', true),
                'business_shortcode' => env('MPESA_BUSINESS_SHORTCODE', ''),
                'passkey' => env('MPESA_PASSKEY', ''),
                'transaction_type' => env('MPESA_TRANSACTION_TYPE', 'CustomerPayBillOnline'),
            ],
            
            // Manual Entry
            'manual_entry' => [
                'enabled' => env('MPESA_MANUAL_ENTRY', true),
                'require_validation' => env('MPESA_REQUIRE_VALIDATION', true),
            ],
            
            // Settings for configuration page
            'settings' => [
                'auto_check_payments' => true,
                'auto_check_minutes' => 5,
                'auto_match_payments' => true,
                'auto_sync_hours' => 24,
                'notification_channels' => ['email', 'sms'],
                'daily_report_time' => '09:00',
                'reconciliation_days' => 30,
                'max_retry_attempts' => 3,
                'retry_delay_minutes' => 5,
                'enable_logging' => true,
                'log_level' => 'info',
            ],
        ],
    
    // ============================================
    // RECEIPTS & PDF SETTINGS
    // ============================================
    'receipts' => [
        'print_mode' => env('RECEIPT_PRINT_MODE', 'html'), // html, pdf, thermal
        'paper_size' => env('RECEIPT_PAPER_SIZE', 'A4'),
        'include_vat' => env('RECEIPT_INCLUDE_VAT', true),
        'template' => env('RECEIPT_TEMPLATE', 'default'),
        'auto_print' => env('RECEIPT_AUTO_PRINT', true),
        'include_qr' => env('RECEIPT_INCLUDE_QR', true),
        'footer_message' => env('RECEIPT_FOOTER_MESSAGE', 'Thank you for your business!'),
        
        // PDF Settings
        'pdf' => [
            'author' => env('APP_NAME', 'Kenyan Supermarket'),
            'creator' => env('APP_NAME', 'Kenyan Supermarket POS'),
            'subject' => 'Sales Receipt',
            'keywords' => 'receipt, invoice, sale, pos',
        ],
    ],
    
    // ============================================
    // CACHING SETTINGS
    // ============================================
    'cache' => [
        'store_info_ttl' => env('STORE_INFO_CACHE_TTL', 3600), // 1 hour
        'products_ttl' => env('PRODUCTS_CACHE_TTL', 1800), // 30 minutes
        'customers_ttl' => env('CUSTOMERS_CACHE_TTL', 3600), // 1 hour
        'payment_methods_ttl' => env('PAYMENT_METHODS_CACHE_TTL', 86400), // 24 hours
        
        // Cache keys
        'keys' => [
            'store_info' => 'store_information',
            'store_info_pos' => 'store_information_pos',
            'store_info_receipt' => 'store_information_receipt',
            'active_payment_methods' => 'active_payment_methods',
            'etims_credentials' => 'etims_credentials_active',
        ],
    ],
    
    // ============================================
    // POS UI & BEHAVIOR SETTINGS
    // ============================================
    'ui' => [
        'theme' => env('POS_THEME', 'light'), // light, dark, auto
        'language' => env('POS_LANGUAGE', 'en'),
        'time_format' => env('TIME_FORMAT', '12'), // 12 or 24
        'date_format' => env('DATE_FORMAT', 'd/m/Y'),
        
        // Features
        'show_product_images' => env('SHOW_PRODUCT_IMAGES', true),
        'quick_actions_enabled' => env('QUICK_ACTIONS_ENABLED', true),
        'keyboard_shortcuts_enabled' => env('KEYBOARD_SHORTCUTS_ENABLED', true),
        'auto_complete_delay' => env('AUTO_COMPLETE_DELAY', 300),
        
        // Cart
        'cart_max_items' => env('CART_MAX_ITEMS', 100),
        'cart_auto_save' => env('CART_AUTO_SAVE', true),
        'cart_auto_save_interval' => env('CART_AUTO_SAVE_INTERVAL', 30000), // milliseconds
    ],
    
    // ============================================
    // SECURITY SETTINGS
    // ============================================
    'security' => [
        'require_pin_for_refunds' => env('REQUIRE_PIN_FOR_REFUNDS', true),
        'require_pin_for_void' => env('REQUIRE_PIN_FOR_VOID', true),
        'require_pin_for_discounts' => env('REQUIRE_PIN_FOR_DISCOUNTS', false),
        'max_discount_percentage' => env('MAX_DISCOUNT_PERCENTAGE', 50),
        'session_timeout' => env('SESSION_TIMEOUT', 30), // minutes
    ],
    
    // ============================================
    // DATABASE MODELS CONFIGURATION
    // ============================================
    'models' => [
        'etims_credentials' => App\Models\ETIMSCredential::class,
        'mpesa_credentials' => App\Models\MpesaCredential::class,
        'store_information' => App\Models\StoreInformation::class,
        'customer' => App\Models\Customer::class,
        'product' => App\Models\Product::class,
        'sale' => App\Models\Sale::class,
        'payment' => App\Models\Payment::class,
    ],
    
    // ============================================
    // SYSTEM SETTINGS
    // ============================================
    'system' => [
        'environment' => env('APP_ENV', 'production'),
        'debug' => env('APP_DEBUG', false),
        'maintenance_mode' => env('MAINTENANCE_MODE', false),
        'backup_enabled' => env('BACKUP_ENABLED', true),
        'sync_interval' => env('SYNC_INTERVAL', 60), // minutes
    ],
];

// ============================================
// LEGACY CONFIGURATION ACCESS
// ============================================
if (!function_exists('get_pos_config')) {
    function get_pos_config($key, $default = null) {
        $config = config('pos');
        
        // Map old keys to new structure
        $legacyMap = [
            'store_name' => ['store', 'name'],
            'store_address' => ['store', 'address'],
            'store_phone' => ['store', 'phone'],
            'vat_number' => ['store', 'vat_number'],
            'kra_pin' => ['store', 'company_pin'],
            'invoice_prefix' => ['invoice', 'prefix'],
            'receipt_footer' => ['invoice', 'footer'],
            'default_vat_rate' => ['vat', 'rate'],
            'currency' => ['currency', 'code'],
            'currency_symbol' => ['currency', 'symbol'],
            'print_automatic' => ['invoice', 'print_automatically'],
            'require_customer' => ['invoice', 'require_customer'],
            'low_stock_threshold' => ['stock', 'low_stock_threshold'],
            'printer_ip' => ['printer', 'network', 'ip'],
            'printer_port' => ['printer', 'network', 'port'],
            'etims_enabled' => ['etims', 'enabled'],
            'etims_api_url' => ['etims', 'api', 'production_url'],
            'mpesa_enabled' => ['mpesa', 'enabled'],
            'mpesa_callback_url' => ['mpesa', 'api', 'callback_url'],
        ];
        
        // Check legacy map first
        if (isset($legacyMap[$key])) {
            $path = $legacyMap[$key];
            $value = $config;
            foreach ($path as $segment) {
                if (isset($value[$segment])) {
                    $value = $value[$segment];
                } else {
                    return $default;
                }
            }
            return $value;
        }
        
        // Try new structure with dot notation
        $segments = explode('.', $key);
        $value = $config;
        
        foreach ($segments as $segment) {
            if (!is_array($value) || !isset($value[$segment])) {
                return $default;
            }
            $value = $value[$segment];
        }
        
        return $value;
    }
}

// Helper function to get store info with fallbacks
if (!function_exists('get_store_info')) {
    function get_store_info($key = null, $default = null) {
        $storeConfig = config('pos.store');
        
        if ($key === null) {
            return $storeConfig;
        }
        
        // Check if key exists in store config
        if (isset($storeConfig[$key])) {
            return $storeConfig[$key];
        }
        
        // Check nested keys
        $segments = explode('.', $key);
        $value = $storeConfig;
        
        foreach ($segments as $segment) {
            if (!is_array($value) || !isset($value[$segment])) {
                return $default;
            }
            $value = $value[$segment];
        }
        
        return $value;
    }
}

// Helper function to check if feature is enabled
if (!function_exists('is_feature_enabled')) {
    function is_feature_enabled($feature) {
        $featureMap = [
            'etims' => config('pos.etims.enabled'),
            'mpesa' => config('pos.mpesa.enabled'),
            'card_payments' => config('pos.payment.methods.card.enabled'),
            'credit_sales' => config('pos.payment.methods.credit.enabled'),
            'split_payments' => config('pos.payment.split_payment_enabled'),
            'barcode_scanner' => config('pos.barcode.scanner_enabled'),
            'auto_print' => config('pos.invoice.print_automatically'),
        ];
        
        return $featureMap[$feature] ?? false;
    }
}