<?php

namespace App\Services\PaymentProviders;

use App\Interfaces\PaymentProviderInterface;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class MpesaProvider implements PaymentProviderInterface
{
    protected array $config;
    
    public function __construct()
    {
        $this->config = config('payment.providers.mpesa', []);
    }
    
    public function getName(): string
    {
        return 'M-Pesa';
    }
    
    public function getCode(): string
    {
        return 'mpesa';
    }
    
    public function getSupportedMethods(): array
    {
        return ['mobile'];
    }
    
    public function initiatePayment(array $data): array
    {
        try {
            // Simulate STK Push request
            $checkoutRequestId = 'ws_CO_' . date('YmdHis') . '_' . rand(100000, 999999);
            
            return [
                'success' => true,
                'reference' => $data['reference'],
                'checkout_request_id' => $checkoutRequestId,
                'provider_reference' => 'MPESA' . time(),
                'message' => 'STK Push initiated. Check your phone.',
                'amount' => $data['amount'],
                'phone' => $data['phone']
            ];
            
        } catch (\Exception $e) {
            Log::error('M-Pesa payment error: ' . $e->getMessage());
            throw $e;
        }
    }
    
    public function verifyPayment(string $reference): array
    {
        // Simulate verification
        return [
            'success' => true,
            'status' => 'completed',
            'amount' => 1000.00, // Example amount
            'transaction_date' => now()->toDateTimeString(),
            'message' => 'Payment verified successfully'
        ];
    }
    
    public function refundPayment(string $reference, float $amount): array
    {
        // Simulate refund
        return [
            'success' => true,
            'refund_reference' => 'RFND-' . time(),
            'amount' => $amount,
            'message' => 'Refund initiated successfully'
        ];
    }
}