<?php

namespace App\Services;

use App\Models\ETIMSCredential;
use App\Models\MpesaCredential;

class CredentialService
{
    public function getETIMSCredentials()
    {
        $source = config('pos.etims.credentials_source', 'database');
        
        if ($source === 'database') {
            $credential = ETIMSCredential::active()->first();
            if ($credential) {
                return [
                    'tin' => $credential->getDecryptedTin(),
                    'consumer_key' => $credential->getDecryptedConsumerKey(),
                    'consumer_secret' => $credential->getDecryptedConsumerSecret(),
                    'api_url' => $credential->api_url ?? config('pos.etims.api_url'),
                    'environment' => $credential->environment,
                    'branch_id' => $credential->branch_id,
                    'branch_name' => $credential->branch_name,
                    'name' => $credential->name,
                ];
            }
        }
        
        // Fallback to env/config
        return [
            'tin' => env('ETIMS_TIN', ''),
            'consumer_key' => config('pos.etims.api_key', ''),
            'consumer_secret' => env('ETIMS_API_SECRET', ''),
            'api_url' => config('pos.etims.api_url'),
            'environment' => env('ETIMS_ENVIRONMENT', 'sandbox'),
            'branch_id' => env('ETIMS_BRANCH_ID', ''),
            'branch_name' => env('ETIMS_BRANCH_NAME', ''),
            'name' => config('pos.store.name'),
        ];
    }
    
    public function getMpesaCredentials()
    {
        $source = config('pos.mpesa.credentials_source', 'database');
        
        if ($source === 'database') {
            $credential = MpesaCredential::active()->first();
            if ($credential) {
                return [
                    'business_shortcode' => $credential->business_shortcode,
                    'consumer_key' => $credential->getDecryptedConsumerKey(),
                    'consumer_secret' => $credential->getDecryptedConsumerSecret(),
                    'passkey' => $credential->getDecryptedPasskey(),
                    'initiator_name' => $credential->initiator_name,
                    'initiator_password' => $credential->getDecryptedInitiatorPassword(),
                    'security_credential' => $credential->getDecryptedSecurityCredential(),
                    'environment' => $credential->environment,
                    'callback_url' => $credential->callback_url ?? config('pos.mpesa.callback_url'),
                    'name' => $credential->name,
                ];
            }
        }
        
        // Fallback to env/config
        return [
            'business_shortcode' => env('MPESA_BUSINESS_SHORTCODE', ''),
            'consumer_key' => env('MPESA_CONSUMER_KEY', ''),
            'consumer_secret' => env('MPESA_CONSUMER_SECRET', ''),
            'passkey' => env('MPESA_PASSKEY', ''),
            'initiator_name' => env('MPESA_INITIATOR_NAME', ''),
            'initiator_password' => env('MPESA_INITIATOR_PASSWORD', ''),
            'security_credential' => env('MPESA_SECURITY_CREDENTIAL', ''),
            'environment' => env('MPESA_ENVIRONMENT', 'sandbox'),
            'callback_url' => config('pos.mpesa.callback_url'),
            'name' => config('pos.store.name'),
        ];
    }
    
    public function getActiveETIMSCredential()
    {
        return ETIMSCredential::active()->first();
    }
    
    public function getActiveMpesaCredential()
    {
        return MpesaCredential::active()->first();
    }
}