<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\User;
use Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Share user statistics with app layout
        View::composer('layouts.app', function ($view) {
            $totalUsers = User::count();
            $activeUsers = User::where('status', true)->count();
            
            $view->with([
                'totalUsers' => $totalUsers,
                'activeUsers' => $activeUsers,
            ]);
        });
    }
}