<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CreditLimitHistory extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'old_limit',
        'new_limit',
        'changed_by',
        'reason',
    ];

    protected $casts = [
        'old_limit' => 'decimal:2',
        'new_limit' => 'decimal:2',
    ];

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }

    public function changer(): BelongsTo
    {
        return $this->belongsTo(User::class, 'changed_by');
    }
}