<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreSupplierRequest extends FormRequest
{
    public function authorize()
    {
        return auth()->check() && auth()->user()->hasAnyRole(['purchaser', 'manager', 'admin']);
    }

    public function rules()
    {
        return [
            'name' => 'required|string|max:255|unique:suppliers,name',
            'email' => 'nullable|email|unique:suppliers,email',
            'phone' => 'nullable|string|max:20',
            'address' => 'nullable|string|max:500',
            'contact_person' => 'nullable|string|max:255',
            'website' => 'nullable|url|max:255',
            'tax_id' => 'nullable|string|max:50',
            'payment_terms' => 'nullable|string|max:100',
            'notes' => 'nullable|string',
            'status' => 'nullable|in:active,inactive',
        ];
    }

    public function messages()
    {
        return [
            'name.required' => 'Supplier name is required',
            'name.unique' => 'A supplier with this name already exists',
            'email.email' => 'Please enter a valid email address',
            'email.unique' => 'This email is already registered',
            'website.url' => 'Please enter a valid website URL',
        ];
    }
}