<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreInformationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'store_name' => 'required|string|max:150',
            'logo' => 'nullable|string|max:500',
            'whatsapp_number' => 'nullable|string|max:20',
            'telephone' => 'required|string|max:20',
            'address' => 'required|string|max:500',
            'company_pin' => 'nullable|string|max:50',
            'email' => 'nullable|email|max:100',
            'city' => 'nullable|string|max:100',
            'country' => 'nullable|string|max:100',
            'currency' => 'nullable|string|max:10|in:KES,USD,EUR,GBP',
            'timezone' => 'nullable|string|max:50',
            'vat_number' => 'nullable|string|max:50',
            'branch_code' => 'nullable|string|max:20',
            'business_registration' => 'nullable|string|max:100',
            'kra_pin' => 'nullable|string|max:20',
            'permit_number' => 'nullable|string|max:50',
            'business_hours' => 'nullable|json',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'store_name.required' => 'Store name is required',
            'telephone.required' => 'Telephone number is required',
            'address.required' => 'Address is required',
            'email.email' => 'Please enter a valid email address',
            'currency.in' => 'Please select a valid currency',
        ];
    }
}