<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\Sale;
use App\Services\NumberGeneratorService;

class GenerateSaleNumbers
{
    protected $numberGenerator;
    
    public function __construct(NumberGeneratorService $numberGenerator)
    {
        $this->numberGenerator = $numberGenerator;
    }
    
    public function handle($request, Closure $next)
    {
        $response = $next($request);
        
        // Check if this is a sale creation endpoint
        if ($request->route()->getName() === 'sales.store' || 
            $request->route()->getName() === 'api.sales.store') {
            
            $content = json_decode($response->getContent(), true);
            
            if (isset($content['sale_id'])) {
                $sale = Sale::find($content['sale_id']);
                if ($sale && !$sale->invoice_no) {
                    $sale->generateNumbers();
                    
                    // Update response with numbers
                    $content['numbers'] = $sale->numbers;
                    $response->setContent(json_encode($content));
                }
            }
        }
        
        return $response;
    }
}