<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;
use App\Models\Printer;

class SettingsApiController extends Controller
{
    public function getStoreSettings()
    {
        try {
            // Get store settings from database or use defaults
            $settings = [
                'name' => config('app.name', 'Kenyan Supermarket'),
                'address' => config('app.address', 'Nairobi CBD'),
                'phone' => config('app.phone', '0700 000 000'),
                'currency' => 'KES',
                'vat_rate' => 16,
                'auto_print_receipts' => false,
                'enable_etims' => false,
                'receipt_footer' => 'Thank you for shopping with us!'
            ];

            // Try to get from database if settings table exists
            try {
                if (class_exists('App\Models\Setting')) {
                    $dbSettings = Setting::where('type', 'store')->get();
                    foreach ($dbSettings as $setting) {
                        $settings[$setting->key] = $setting->value;
                    }
                }
            } catch (\Exception $e) {
                // Use defaults if database error
            }

            return response()->json([
                'success' => true,
                'data' => $settings,
                'message' => 'Store settings loaded successfully'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to load store settings: ' . $e->getMessage()
            ], 500);
        }
    }

    public function getPrinterSettings()
    {
        try {
            $settings = [
                'enabled' => false,
                'connected' => false,
                'printer_name' => 'Thermal Printer',
                'printer_type' => 'thermal',
                'paper_width' => 80,
                'auto_print' => false
            ];

            // Try to get from database if printers table exists
            try {
                if (class_exists('App\Models\Printer')) {
                    $printer = Printer::where('is_default', true)->first();
                    if ($printer) {
                        $settings = [
                            'enabled' => $printer->is_active,
                            'connected' => true, // Assuming connected
                            'printer_name' => $printer->name,
                            'printer_type' => $printer->type,
                            'paper_width' => $printer->paper_width,
                            'auto_print' => $printer->auto_print
                        ];
                    }
                }
            } catch (\Exception $e) {
                // Use defaults
            }

            return response()->json([
                'success' => true,
                'data' => $settings,
                'message' => 'Printer settings loaded successfully'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to load printer settings'
            ], 500);
        }
    }

    public function checkPrinterConnection()
    {
        try {
            // Simple printer check
            return response()->json([
                'success' => true,
                'connected' => false,
                'message' => 'Printer is not connected (mock)'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Printer check failed'
            ], 500);
        }
    }
}