<?php

namespace App\Helpers;

class RoleHelper
{
    public static function getIcon($roleName)
    {
        $icons = [
            'super-admin' => 'crown',
            'admin' => 'user-check',
            'manager' => 'briefcase',
            'cashier' => 'receipt',
            'purchaser' => 'shopping-bag',
        ];

        return $icons[strtolower($roleName)] ?? 'user';
    }

    public static function getColor($roleName)
    {
        $colors = [
            'super-admin' => 'danger',
            'admin' => 'primary',
            'manager' => 'warning',
            'cashier' => 'success',
            'purchaser' => 'info',
        ];

        return $colors[strtolower($roleName)] ?? 'secondary';
    }

    public static function getPermissions($roleName)
    {
        $permissions = [
            'super-admin' => ['all'],
            'admin' => [
                'view users', 'create users', 'edit users', 'delete users',
                'view roles', 'edit roles',
                'view products', 'create products', 'edit products', 'delete products',
                'view sales', 'create sales', 'edit sales',
                'view purchases', 'create purchases', 'edit purchases',
                'view customers', 'create customers', 'edit customers',
                'view suppliers', 'create suppliers', 'edit suppliers',
                'view reports', 'generate reports',
                'view settings',
            ],
            'manager' => [
                'view users',
                'view products', 'edit products',
                'view sales', 'create sales', 'edit sales',
                'view purchases',
                'view customers', 'edit customers',
                'view suppliers',
                'view reports', 'generate reports',
                'view settings',
            ],
            'cashier' => [
                'view products',
                'view sales', 'create sales',
                'view customers', 'create customers',
            ],
            'purchaser' => [
                'view products',
                'view purchases', 'create purchases',
                'view suppliers', 'create suppliers',
            ],
        ];

        return $permissions[strtolower($roleName)] ?? [];
    }
}